/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.SameThreadOrderedSafeExecutor;
import org.apache.pulsar.broker.intercept.CounterBrokerInterceptor;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.MockZooKeeperSession;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionTestBase
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(TransactionTestBase.class);
    public static final String CLUSTER_NAME = "test";
    private int brokerCount = 3;
    private final List<SameThreadOrderedSafeExecutor> orderedExecutorList = new ArrayList<SameThreadOrderedSafeExecutor>();
    private final List<ServiceConfiguration> serviceConfigurationList = new ArrayList<ServiceConfiguration>();
    protected final List<PulsarService> pulsarServiceList = new ArrayList<PulsarService>();
    protected PulsarAdmin admin;
    protected PulsarClient pulsarClient;
    private MockZooKeeper mockZooKeeper;
    private OrderedExecutor bkExecutor;
    private NonClosableMockBookKeeper mockBookKeeper;
    public static final String TENANT = "tnx";
    protected static final String NAMESPACE1 = "tnx/ns1";
    protected static final String NAMESPACE3 = "tnx/ns3";
    protected ServiceConfiguration conf = new ServiceConfiguration();
    protected ZooKeeperClientFactory mockZooKeeperClientFactory = new ZooKeeperClientFactory(){

        public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
            return CompletableFuture.completedFuture(TransactionTestBase.this.mockZooKeeper);
        }
    };
    private final BookKeeperClientFactory mockBookKeeperClientFactory = new BookKeeperClientFactory(){

        public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) {
            return TransactionTestBase.this.mockBookKeeper;
        }

        public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties, StatsLogger statsLogger) {
            return TransactionTestBase.this.mockBookKeeper;
        }

        public void close() {
        }
    };

    public void internalSetup() throws Exception {
        this.incrementSetupNumber();
        this.init();
        if (this.admin != null) {
            this.admin.close();
        }
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.pulsarServiceList.get(0).getWebServiceAddress()).build());
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.pulsarServiceList.get(0).getBrokerServiceUrl()).build();
    }

    private void init() throws Exception {
        this.mockZooKeeper = TransactionTestBase.createMockZooKeeper();
        this.bkExecutor = OrderedExecutor.newBuilder().numThreads(1).name("mock-pulsar-bk").build();
        this.mockBookKeeper = TransactionTestBase.createMockBookKeeper(this.bkExecutor);
        this.startBroker();
    }

    protected void setUpBase(int numBroker, int numPartitionsOfTC, String topic, int numPartitions) throws Exception {
        this.setBrokerCount(numBroker);
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster(CLUSTER_NAME, ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{CLUSTER_NAME})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), numPartitionsOfTC);
        if (topic != null) {
            this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{CLUSTER_NAME})));
            this.admin.namespaces().createNamespace(NAMESPACE1);
            this.admin.namespaces().createNamespace(NAMESPACE3);
            if (numPartitions == 0) {
                this.admin.topics().createNonPartitionedTopic(topic);
            } else {
                this.admin.topics().createPartitionedTopic(topic, numPartitions);
            }
        }
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
    }

    protected void startBroker() throws Exception {
        for (int i = 0; i < this.brokerCount; ++i) {
            this.conf.setClusterName(CLUSTER_NAME);
            this.conf.setAdvertisedAddress("localhost");
            this.conf.setManagedLedgerCacheSizeMB(8);
            this.conf.setActiveConsumerFailoverDelayTimeMillis(0);
            this.conf.setDefaultNumberOfNamespaceBundles(1);
            this.conf.setZookeeperServers("localhost:2181");
            this.conf.setConfigurationStoreServers("localhost:3181");
            this.conf.setAllowAutoTopicCreationType("non-partitioned");
            this.conf.setBookkeeperClientExposeStatsToPrometheus(true);
            this.conf.setForceDeleteNamespaceAllowed(true);
            this.conf.setBrokerShutdownTimeoutMs(0L);
            this.conf.setBrokerServicePort(Optional.of(0));
            this.conf.setBrokerServicePortTls(Optional.of(0));
            this.conf.setAdvertisedAddress("localhost");
            this.conf.setWebServicePort(Optional.of(0));
            this.conf.setWebServicePortTls(Optional.of(0));
            this.conf.setTransactionCoordinatorEnabled(true);
            this.conf.setBrokerDeduplicationEnabled(true);
            this.conf.setSystemTopicEnabled(true);
            this.conf.setTransactionBufferSnapshotMaxTransactionCount(2);
            this.conf.setTransactionBufferSnapshotMinTimeInMillis(2000);
            this.conf.setTopicLevelPoliciesEnabled(true);
            this.serviceConfigurationList.add(this.conf);
            PulsarService pulsar = BrokerTestUtil.spyWithClassAndConstructorArgs(PulsarService.class, this.conf);
            this.setupBrokerMocks(pulsar);
            pulsar.start();
            this.pulsarServiceList.add(pulsar);
        }
    }

    protected void setupBrokerMocks(PulsarService pulsar) throws Exception {
        ((PulsarService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)pulsar)).getZooKeeperClientFactory();
        ((PulsarService)Mockito.doReturn((Object)this.mockBookKeeperClientFactory).when((Object)pulsar)).newBookKeeperClientFactory();
        MockZooKeeperSession mockZooKeeperSession = MockZooKeeperSession.newInstance((MockZooKeeper)this.mockZooKeeper);
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeperSession)).when((Object)pulsar)).createLocalMetadataStore();
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeperSession)).when((Object)pulsar)).createConfigurationMetadataStore();
        Supplier<NamespaceService> namespaceServiceSupplier = () -> BrokerTestUtil.spyWithClassAndConstructorArgs(NamespaceService.class, pulsar);
        ((PulsarService)Mockito.doReturn(namespaceServiceSupplier).when((Object)pulsar)).getNamespaceServiceProvider();
        SameThreadOrderedSafeExecutor executor = new SameThreadOrderedSafeExecutor();
        this.orderedExecutorList.add(executor);
        ((PulsarService)Mockito.doReturn((Object)((Object)executor)).when((Object)pulsar)).getOrderedExecutor();
        ((PulsarService)Mockito.doReturn((Object)new CounterBrokerInterceptor()).when((Object)pulsar)).getBrokerInterceptor();
        ((PulsarService)Mockito.doAnswer(invocation -> Mockito.spy((Object)invocation.callRealMethod())).when((Object)pulsar)).newCompactor();
    }

    public static MockZooKeeper createMockZooKeeper() throws Exception {
        MockZooKeeper zk = MockZooKeeper.newInstance((ExecutorService)MoreExecutors.newDirectExecutorService());
        ArrayList dummyAclList = new ArrayList(0);
        ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)"/ledgers/available/192.168.1.1:5000", (byte[])"".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, (CreateMode)CreateMode.PERSISTENT);
        zk.create("/ledgers/LAYOUT", "1\nflat:1".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, CreateMode.PERSISTENT);
        return zk;
    }

    public static NonClosableMockBookKeeper createMockBookKeeper(OrderedExecutor executor) throws Exception {
        return (NonClosableMockBookKeeper)((Object)Mockito.spy((Object)((Object)new NonClosableMockBookKeeper(executor))));
    }

    protected final void internalCleanup() {
        block15: {
            this.markCurrentSetupNumberCleaned();
            try {
                if (this.admin != null) {
                    this.admin.close();
                    this.admin = null;
                }
                if (this.pulsarClient != null) {
                    this.pulsarClient.close();
                    this.pulsarClient = null;
                }
                if (this.pulsarServiceList.size() > 0) {
                    for (PulsarService pulsarService : this.pulsarServiceList) {
                        pulsarService.close();
                    }
                    this.pulsarServiceList.clear();
                }
                if (this.serviceConfigurationList.size() > 0) {
                    this.serviceConfigurationList.clear();
                }
                if (this.mockBookKeeper != null) {
                    this.mockBookKeeper.reallyShutdown();
                }
                if (this.mockZooKeeper != null) {
                    this.mockZooKeeper.shutdown();
                }
                if (this.orderedExecutorList.size() > 0) {
                    for (int i = 0; i < this.orderedExecutorList.size(); ++i) {
                        SameThreadOrderedSafeExecutor sameThreadOrderedSafeExecutor = this.orderedExecutorList.get(i);
                        if (sameThreadOrderedSafeExecutor == null) continue;
                        try {
                            sameThreadOrderedSafeExecutor.shutdownNow();
                            sameThreadOrderedSafeExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex) {
                            log.error("sameThreadOrderedSafeExecutor shutdown had error", (Throwable)ex);
                            Thread.currentThread().interrupt();
                        }
                        this.orderedExecutorList.set(i, null);
                    }
                }
                if (this.bkExecutor == null) break block15;
                try {
                    this.bkExecutor.shutdownNow();
                    this.bkExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    log.error("bkExecutor shutdown had error", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                this.bkExecutor = null;
            }
            catch (Exception e) {
                log.warn("Failed to clean up mocked pulsar service:", (Throwable)e);
            }
        }
    }

    public void setBrokerCount(int brokerCount) {
        this.brokerCount = brokerCount;
    }

    public List<ServiceConfiguration> getServiceConfigurationList() {
        return this.serviceConfigurationList;
    }

    public List<PulsarService> getPulsarServiceList() {
        return this.pulsarServiceList;
    }

    public static class NonClosableMockBookKeeper
    extends PulsarMockBookKeeper {
        public NonClosableMockBookKeeper(OrderedExecutor executor) throws Exception {
            super(executor);
        }

        public void close() {
        }

        public void shutdown() {
        }

        public void reallyShutdown() {
            super.shutdown();
        }
    }
}

