/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.transaction.buffer.TransactionEntry;
import org.apache.pulsar.broker.transaction.buffer.impl.InMemTransactionBufferReader;
import org.apache.pulsar.broker.transaction.exception.buffer.TransactionBufferException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class InMemTransactionBufferReaderTest {
    private final TxnID txnID = new TxnID(1234L, 5678L);

    @Test
    public void testInvalidNumEntriesArgument() {
        try (InMemTransactionBufferReader reader = new InMemTransactionBufferReader(this.txnID, Collections.emptySortedMap().entrySet().iterator(), 22L, 33L);){
            try {
                reader.readNext(-1).join();
                Assert.fail((String)"Should fail to readNext if `numEntries` is invalid");
            }
            catch (CompletionException ce) {
                Assert.assertTrue((boolean)(ce.getCause() instanceof IllegalArgumentException));
            }
        }
    }

    @Test
    public void testCloseReleaseAllEntries() throws Exception {
        TreeMap<Long, ByteBuf> entries = new TreeMap<Long, ByteBuf>();
        int numEntries = 100;
        for (int i = 0; i < 100; ++i) {
            entries.put(Long.valueOf(i), Unpooled.copiedBuffer((CharSequence)("message-" + i), (Charset)StandardCharsets.UTF_8));
        }
        try (InMemTransactionBufferReader reader = new InMemTransactionBufferReader(this.txnID, entries.entrySet().iterator(), 22L, 33L);){
            int numEntriesToRead = 10;
            List txnEntries = (List)reader.readNext(numEntriesToRead).get();
            this.verifyAndReleaseEntries(txnEntries, this.txnID, 0L, numEntriesToRead);
            this.verifyEntriesReleased(entries, 0L, numEntriesToRead);
        }
        this.verifyEntriesReleased(entries, 10L, 90);
    }

    @Test
    public void testEndOfTransactionException() throws Exception {
        TreeMap<Long, ByteBuf> entries = new TreeMap<Long, ByteBuf>();
        int numEntries = 100;
        for (int i = 0; i < 100; ++i) {
            entries.put(Long.valueOf(i), Unpooled.copiedBuffer((CharSequence)("message-" + i), (Charset)StandardCharsets.UTF_8));
        }
        try (InMemTransactionBufferReader reader = new InMemTransactionBufferReader(this.txnID, entries.entrySet().iterator(), 22L, 33L);){
            int numEntriesToRead = 110;
            List txnEntries = (List)reader.readNext(numEntriesToRead).get();
            this.verifyAndReleaseEntries(txnEntries, this.txnID, 0L, 100);
            this.verifyEntriesReleased(entries, 0L, 100);
            try {
                reader.readNext(1).get();
                Assert.fail((String)"should fail to read entries if there is no more in the transaction buffer");
            }
            catch (ExecutionException ee) {
                Assert.assertTrue((boolean)(ee.getCause() instanceof TransactionBufferException.EndOfTransactionException));
            }
        }
    }

    private void verifyAndReleaseEntries(List<TransactionEntry> txnEntries, TxnID txnID, long startSequenceId, int numEntriesToRead) {
        Assert.assertEquals((int)txnEntries.size(), (int)numEntriesToRead);
        for (int i = 0; i < numEntriesToRead; ++i) {
            try (TransactionEntry txnEntry = txnEntries.get(i);){
                Assert.assertEquals((long)txnEntry.committedAtLedgerId(), (long)22L);
                Assert.assertEquals((long)txnEntry.committedAtEntryId(), (long)33L);
                Assert.assertEquals((Object)txnEntry.txnId(), (Object)txnID);
                Assert.assertEquals((long)txnEntry.sequenceId(), (long)(startSequenceId + (long)i));
                Assert.assertEquals((String)new String(ByteBufUtil.getBytes((ByteBuf)txnEntry.getEntry().getDataBuffer()), StandardCharsets.UTF_8), (String)("message-" + i));
                continue;
            }
        }
    }

    private void verifyEntriesReleased(SortedMap<Long, ByteBuf> entries, long startSequenceId, int numEntriesToRead) {
        for (int i = 0; i < numEntriesToRead; ++i) {
            long sequenceId = startSequenceId + (long)i;
            ByteBuf bb = (ByteBuf)entries.get(sequenceId);
            Assert.assertNotNull((Object)bb);
            Assert.assertEquals((int)bb.refCnt(), (int)0);
        }
    }
}

