/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreState;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.awaitility.Awaitility;
import org.powermock.reflect.Whitebox;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TopicTransactionBufferTest
extends TransactionTestBase {
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.setBrokerCount(1);
        this.setUpBase(1, 16, "persistent://tnx/ns1/test", 0);
        Map stores = this.getPulsarServiceList().get(0).getTransactionMetadataStoreService().getStores();
        Awaitility.await().until(() -> {
            if (stores.size() == 16) {
                for (TransactionCoordinatorID transactionCoordinatorID : stores.keySet()) {
                    if (((MLTransactionMetadataStore)stores.get(transactionCoordinatorID)).getState() == TransactionMetadataStoreState.State.Ready) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testTransactionBufferAppendMarkerWriteFailState() throws Exception {
        String topic = "persistent://tnx/ns1/testPendingAckManageLedgerWriteFailState";
        Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://tnx/ns1/testPendingAckManageLedgerWriteFailState").sendTimeout(0, TimeUnit.SECONDS).enableBatching(false).create();
        producer.newMessage(txn).value((Object)"test".getBytes()).send();
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(TopicName.get((String)"persistent://tnx/ns1/testPendingAckManageLedgerWriteFailState").toString(), false).get()).get();
        Whitebox.setInternalState((Object)persistentTopic.getManagedLedger(), (String)"state", (Object)ManagedLedgerImpl.State.WriteFailed);
        txn.commit().get();
    }
}

