/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionBufferCloseTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferCloseTest.class);

    @BeforeMethod
    protected void setup() throws Exception {
        this.setUpBase(1, 16, null, 0);
        Awaitility.await().until(() -> ((PulsarClientImpl)this.pulsarClient).getTcClient().getState() == TransactionCoordinatorClient.State.READY);
        this.admin.tenants().createTenant("tnx", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="isPartition")
    public Object[][] isPartition() {
        return new Object[][]{{true}, {false}};
    }

    @Test(timeOut=10000L, dataProvider="isPartition")
    public void deleteTopicCloseTransactionBufferTest(boolean isPartition) throws Exception {
        int expectedCount = isPartition ? 30 : 1;
        TopicName topicName = this.createAndLoadTopic(isPartition, expectedCount);
        this.checkSnapshotPublisherCount(topicName.getNamespace(), expectedCount);
        if (isPartition) {
            this.admin.topics().deletePartitionedTopic(topicName.getPartitionedTopicName(), true);
        } else {
            this.admin.topics().delete(topicName.getPartitionedTopicName(), true);
        }
        this.checkSnapshotPublisherCount(topicName.getNamespace(), 0);
    }

    @Test(timeOut=10000L, dataProvider="isPartition")
    public void unloadTopicCloseTransactionBufferTest(boolean isPartition) throws Exception {
        int expectedCount = isPartition ? 30 : 1;
        TopicName topicName = this.createAndLoadTopic(isPartition, expectedCount);
        this.checkSnapshotPublisherCount(topicName.getNamespace(), expectedCount);
        this.admin.topics().unload(topicName.getPartitionedTopicName());
        this.checkSnapshotPublisherCount(topicName.getNamespace(), 0);
    }

    private TopicName createAndLoadTopic(boolean isPartition, int partitionCount) throws PulsarAdminException, PulsarClientException {
        String namespace = "tnx/ns-" + RandomStringUtils.randomAlphabetic((int)5);
        this.admin.namespaces().createNamespace(namespace, 3);
        String topic = namespace + "/tb-close-test-";
        if (isPartition) {
            this.admin.topics().createPartitionedTopic(topic, partitionCount);
        }
        this.pulsarClient.newProducer().topic(topic).sendTimeout(0, TimeUnit.SECONDS).create().close();
        return TopicName.get((String)topic);
    }

    private void checkSnapshotPublisherCount(String namespace, int expectCount) throws PulsarAdminException {
        TopicName snTopicName = TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.get((String)namespace), (String)"__transaction_buffer_snapshot");
        List publisherStatsList = this.admin.topics().getStats(snTopicName.getPartitionedTopicName()).getPublishers();
        Assert.assertEquals((int)publisherStatsList.size(), (int)expectCount);
    }
}

