/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferHandlerImpl;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionBufferHandlerImplTest {
    @Test
    public void testRequestCredits() throws PulsarServerException {
        int i;
        PulsarClient pulsarClient = (PulsarClient)Mockito.mock(PulsarClientImpl.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        NamespaceService namespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        Mockito.when((Object)pulsarService.getNamespaceService()).thenReturn((Object)namespaceService);
        Mockito.when((Object)pulsarService.getClient()).thenReturn((Object)pulsarClient);
        Mockito.when((Object)namespaceService.getBundleAsync((TopicName)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(Mockito.mock(NamespaceBundle.class)));
        Optional opData = Optional.empty();
        Mockito.when((Object)namespaceService.getOwnerAsync((NamespaceBundle)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(opData));
        Mockito.when((Object)((PulsarClientImpl)pulsarClient).getConnection(ArgumentMatchers.anyString())).thenReturn(CompletableFuture.completedFuture(Mockito.mock(ClientCnx.class)));
        TransactionBufferHandlerImpl handler = (TransactionBufferHandlerImpl)Mockito.spy((Object)new TransactionBufferHandlerImpl(pulsarService, null, 1000, 3000L));
        ((TransactionBufferHandlerImpl)Mockito.doNothing().when((Object)handler)).endTxn((TransactionBufferHandlerImpl.OpRequestSend)ArgumentMatchers.any());
        ((TransactionBufferHandlerImpl)Mockito.doReturn(CompletableFuture.completedFuture(Mockito.mock(ClientCnx.class))).when((Object)handler)).getClientCnx(ArgumentMatchers.anyString());
        for (i = 0; i < 500; ++i) {
            handler.endTxnOnTopic("public/default/t", 1L, 1L, TxnAction.COMMIT, 1L);
        }
        Assert.assertEquals((int)handler.getAvailableRequestCredits(), (int)500);
        for (i = 0; i < 500; ++i) {
            handler.endTxnOnTopic("public/default/t", 1L, 1L, TxnAction.COMMIT, 1L);
        }
        Assert.assertEquals((int)handler.getAvailableRequestCredits(), (int)0);
        handler.endTxnOnTopic("public/default/t", 1L, 1L, TxnAction.COMMIT, 1L);
        Assert.assertEquals((int)handler.getPendingRequestsCount(), (int)1);
        handler.onResponse(null);
        Assert.assertEquals((int)handler.getAvailableRequestCredits(), (int)0);
        Assert.assertEquals((int)handler.getPendingRequestsCount(), (int)0);
    }

    @Test
    public void testMinRequestCredits() throws PulsarServerException {
        PulsarClient pulsarClient = (PulsarClient)Mockito.mock(PulsarClientImpl.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        Mockito.when((Object)pulsarService.getClient()).thenReturn((Object)pulsarClient);
        TransactionBufferHandlerImpl handler = (TransactionBufferHandlerImpl)Mockito.spy((Object)new TransactionBufferHandlerImpl(pulsarService, null, 50, 3000L));
        Assert.assertEquals((int)handler.getAvailableRequestCredits(), (int)100);
    }
}

