/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferState;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionStablePositionTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionStablePositionTest.class);
    private static final String TOPIC = "tnx/ns1/test-topic";

    @BeforeMethod
    protected void setup() throws Exception {
        this.setUpBase(1, 16, TOPIC, 0);
        Awaitility.await().until(() -> ((PulsarClientImpl)this.pulsarClient).getTcClient().getState() == TransactionCoordinatorClient.State.READY);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void commitTxnTest() throws Exception {
        Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
        Producer producer = this.pulsarClient.newProducer().topic(TOPIC).sendTimeout(0, TimeUnit.SECONDS).enableBatching(false).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{TOPIC}).subscriptionName("test").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Failover).subscribe();
        String TEST1 = "test1";
        String TEST2 = "test2";
        String TEST3 = "test3";
        producer.newMessage().value((Object)"test1".getBytes()).send();
        producer.newMessage(txn).value((Object)"test2".getBytes()).send();
        producer.newMessage().value((Object)"test3".getBytes()).send();
        Message message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test1");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
        txn.commit().get();
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test2");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test3");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
    }

    @Test
    public void abortTxnTest() throws Exception {
        Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
        Producer producer = this.pulsarClient.newProducer().topic(TOPIC).sendTimeout(0, TimeUnit.SECONDS).enableBatching(false).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{TOPIC}).subscriptionName("test").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Failover).subscribe();
        String TEST1 = "test1";
        String TEST2 = "test2";
        String TEST3 = "test3";
        producer.newMessage().value((Object)"test1".getBytes()).send();
        producer.newMessage(txn).value((Object)"test2".getBytes()).send();
        producer.newMessage().value((Object)"test3".getBytes()).send();
        Message message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test1");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
        txn.abort().get();
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test3");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
    }

    @DataProvider(name="enableTransactionAndState")
    public static Object[][] enableTransactionAndState() {
        return new Object[][]{{true, TopicTransactionBufferState.State.None}, {false, TopicTransactionBufferState.State.None}, {true, TopicTransactionBufferState.State.Initializing}, {false, TopicTransactionBufferState.State.Initializing}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="enableTransactionAndState")
    public void testSyncNormalPositionWhenTBRecover(boolean clientEnableTransaction, TopicTransactionBufferState.State state) throws Exception {
        String topicName = "tnx/ns1/testSyncNormalPositionWhenTBRecover-" + clientEnableTransaction + state.name();
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(clientEnableTransaction).build();
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic(topicName).create();
        try {
            PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.getPulsarServiceList().get(0).getBrokerService().getTopic(TopicName.get((String)topicName).toString(), false).get()).get();
            TopicTransactionBuffer topicTransactionBuffer = (TopicTransactionBuffer)persistentTopic.getTransactionBuffer();
            this.checkTopicTransactionBufferState(clientEnableTransaction, topicTransactionBuffer);
            Field field = TopicTransactionBufferState.class.getDeclaredField("state");
            field.setAccessible(true);
            field.set(topicTransactionBuffer, state);
            PositionImpl position = topicTransactionBuffer.getMaxReadPosition();
            Assert.assertEquals((Object)position, (Object)PositionImpl.earliest);
            MessageIdImpl messageId = (MessageIdImpl)producer.send((Object)"test".getBytes());
            position = topicTransactionBuffer.getMaxReadPosition();
            Assert.assertEquals((Object)position, (Object)PositionImpl.earliest);
            Method method = TopicTransactionBuffer.class.getDeclaredMethod("recover", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)topicTransactionBuffer, new Object[0]);
            field.set(topicTransactionBuffer, TopicTransactionBufferState.State.None);
            this.checkTopicTransactionBufferState(clientEnableTransaction, topicTransactionBuffer);
            Assert.assertEquals((Object)PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId()), (Object)topicTransactionBuffer.getMaxReadPosition());
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    private void checkTopicTransactionBufferState(boolean clientEnableTransaction, TopicTransactionBuffer topicTransactionBuffer) {
        Awaitility.await().until(() -> {
            if (clientEnableTransaction) {
                return topicTransactionBuffer.getStats().state.equals(TopicTransactionBufferState.State.Ready.name());
            }
            return topicTransactionBuffer.getStats().state.equals(TopicTransactionBufferState.State.NoSnapshot.name());
        });
    }
}

