/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.coordinator;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransactionMetaStoreAssignmentTest
extends TransactionTestBase {
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.setUpBase(3, 16, null, 0);
        this.pulsarClient.close();
    }

    @Test
    public void testTransactionMetaStoreAssignAndFailover() throws Exception {
        this.pulsarClient = this.buildClient();
        this.checkTransactionCoordinatorNum(16);
        this.pulsarClient.close();
        PulsarService crashedMetaStore = null;
        for (int i = this.pulsarServiceList.size() - 1; i >= 0; --i) {
            if (((PulsarService)this.pulsarServiceList.get(i)).getTransactionMetadataStoreService().getStores().size() <= 0) continue;
            crashedMetaStore = (PulsarService)this.pulsarServiceList.get(i);
            break;
        }
        Assert.assertNotNull(crashedMetaStore);
        this.pulsarServiceList.remove(crashedMetaStore);
        crashedMetaStore.close();
        this.pulsarClient = this.buildClient();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            int transactionMetaStoreCount2 = this.pulsarServiceList.stream().mapToInt(pulsarService -> pulsarService.getTransactionMetadataStoreService().getStores().size()).sum();
            Assert.assertEquals((int)transactionMetaStoreCount2, (int)16);
        });
        this.pulsarClient.close();
    }

    @Test
    public void testTransactionMetaStoreUnload() throws Exception {
        this.pulsarClient = this.buildClient();
        this.checkTransactionCoordinatorNum(16);
        this.pulsarClient.close();
        this.admin.topics().unload(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
        int i = 0;
        while (i < 16) {
            int f = i++;
            this.pulsarServiceList.forEach(pulsarService -> pulsarService.getTransactionMetadataStoreService().removeTransactionMetadataStore(TransactionCoordinatorID.get((long)f)));
        }
        this.checkTransactionCoordinatorNum(0);
        this.buildClient();
        this.checkTransactionCoordinatorNum(16);
        this.pulsarClient.close();
    }

    private void checkTransactionCoordinatorNum(int number) {
        Awaitility.await().untilAsserted(() -> {
            int transactionMetaStoreCount = this.pulsarServiceList.stream().mapToInt(pulsarService -> pulsarService.getTransactionMetadataStoreService().getStores().size()).sum();
            Assert.assertEquals((int)transactionMetaStoreCount, (int)number);
        });
    }

    private PulsarClient buildClient() throws Exception {
        return PulsarClient.builder().serviceUrlProvider(new ServiceUrlProvider(){
            final AtomicInteger atomicInteger = new AtomicInteger();

            public void initialize(PulsarClient client) {
            }

            public String getServiceUrl() {
                return ((PulsarService)TransactionMetaStoreAssignmentTest.this.pulsarServiceList.get(this.atomicInteger.getAndIncrement() % TransactionMetaStoreAssignmentTest.this.pulsarServiceList.size())).getBrokerServiceUrl();
            }
        }).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }
}

