/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStore;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class PendingAckMetadataTest
extends MockedBookKeeperTestCase {
    public PendingAckMetadataTest() {
        super(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingAckManageLedgerWriteFailState() throws Exception {
        ManagedLedgerFactoryConfig factoryConf = new ManagedLedgerFactoryConfig();
        factoryConf.setMaxCacheSize(0L);
        String pendingAckTopicName = MLPendingAckStore.getTransactionPendingAckStoreSuffix((String)"test", (String)"test");
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc, factoryConf);
        try {
            final CompletableFuture completableFuture = new CompletableFuture();
            factory.asyncOpen(pendingAckTopicName, new AsyncCallbacks.OpenLedgerCallback(){

                public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                    completableFuture.complete(ledger);
                }

                public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                }
            }, null);
            ManagedCursor cursor = ((ManagedLedger)completableFuture.get()).openCursor("test");
            ManagedCursor subCursor = ((ManagedLedger)completableFuture.get()).openCursor("test");
            MLPendingAckStore pendingAckStore = new MLPendingAckStore((ManagedLedger)completableFuture.get(), cursor, subCursor, 500L);
            Field field = MLPendingAckStore.class.getDeclaredField("managedLedger");
            field.setAccessible(true);
            ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)field.get(pendingAckStore);
            field = ManagedLedgerImpl.class.getDeclaredField("STATE_UPDATER");
            field.setAccessible(true);
            AtomicReferenceFieldUpdater state = (AtomicReferenceFieldUpdater)field.get(managedLedger);
            state.set(managedLedger, ManagedLedgerImpl.State.WriteFailed);
            try {
                pendingAckStore.appendAbortMark(new TxnID(1L, 1L), CommandAck.AckType.Cumulative).get();
                AssertJUnit.fail();
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause().getCause() instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException));
            }
            pendingAckStore.appendAbortMark(new TxnID(1L, 1L), CommandAck.AckType.Cumulative).get();
            ((ManagedLedger)completableFuture.get()).close();
            cursor.close();
            subCursor.close();
        }
        finally {
            if (Collections.singletonList(factory).get(0) != null) {
                factory.shutdown();
            }
        }
    }
}

