/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.recover;

import io.netty.util.HashedWheelTimer;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.transaction.recover.TransactionRecoverTrackerImpl;
import org.apache.pulsar.broker.transaction.timeout.TransactionTimeoutTrackerFactoryImpl;
import org.apache.pulsar.broker.transaction.timeout.TransactionTimeoutTrackerImpl;
import org.apache.pulsar.common.util.collections.TripleLongPriorityQueue;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionTimeoutTracker;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TransactionRecoverTrackerTest {
    @Test
    public void openStatusRecoverTrackerTest() throws Exception {
        TransactionMetadataStoreService transactionMetadataStoreService = (TransactionMetadataStoreService)Mockito.mock(TransactionMetadataStoreService.class);
        TransactionTimeoutTracker timeoutTracker = new TransactionTimeoutTrackerFactoryImpl(transactionMetadataStoreService, new HashedWheelTimer()).newTracker(TransactionCoordinatorID.get((long)1L));
        TransactionRecoverTrackerImpl recoverTracker = new TransactionRecoverTrackerImpl(transactionMetadataStoreService, timeoutTracker, 1L);
        recoverTracker.handleOpenStatusTransaction(1L, 200L);
        recoverTracker.handleOpenStatusTransaction(2L, 300L);
        Field field = TransactionRecoverTrackerImpl.class.getDeclaredField("openTransactions");
        field.setAccessible(true);
        Map map = (Map)field.get(recoverTracker);
        AssertJUnit.assertEquals((int)map.size(), (int)2);
        AssertJUnit.assertEquals((long)((Long)map.get(1L)), (long)200L);
        AssertJUnit.assertEquals((long)((Long)map.get(2L)), (long)300L);
        field = TransactionTimeoutTrackerImpl.class.getDeclaredField("priorityQueue");
        field.setAccessible(true);
        TripleLongPriorityQueue priorityQueue = (TripleLongPriorityQueue)field.get(timeoutTracker);
        AssertJUnit.assertEquals((long)priorityQueue.size(), (long)0L);
        recoverTracker.appendOpenTransactionToTimeoutTracker();
        AssertJUnit.assertEquals((long)priorityQueue.size(), (long)2L);
    }

    @Test
    public void updateStatusRecoverTest() throws Exception {
        TransactionRecoverTrackerImpl recoverTracker = new TransactionRecoverTrackerImpl((TransactionMetadataStoreService)Mockito.mock(TransactionMetadataStoreService.class), (TransactionTimeoutTracker)Mockito.mock(TransactionTimeoutTrackerImpl.class), 1L);
        long committingSequenceId = 1L;
        long committedSequenceId = 2L;
        long abortingSequenceId = 3L;
        long abortedSequenceId = 4L;
        recoverTracker.handleOpenStatusTransaction(committingSequenceId, 100L);
        recoverTracker.handleOpenStatusTransaction(committedSequenceId, 100L);
        recoverTracker.handleOpenStatusTransaction(abortingSequenceId, 100L);
        recoverTracker.handleOpenStatusTransaction(abortedSequenceId, 100L);
        Field field = TransactionRecoverTrackerImpl.class.getDeclaredField("openTransactions");
        field.setAccessible(true);
        Map openMap = (Map)field.get(recoverTracker);
        AssertJUnit.assertEquals((int)4, (int)openMap.size());
        recoverTracker.updateTransactionStatus(committingSequenceId, TxnStatus.COMMITTING);
        AssertJUnit.assertEquals((int)3, (int)openMap.size());
        recoverTracker.updateTransactionStatus(committedSequenceId, TxnStatus.COMMITTING);
        AssertJUnit.assertEquals((int)2, (int)openMap.size());
        recoverTracker.updateTransactionStatus(committedSequenceId, TxnStatus.COMMITTED);
        recoverTracker.updateTransactionStatus(abortingSequenceId, TxnStatus.ABORTING);
        AssertJUnit.assertEquals((int)1, (int)openMap.size());
        recoverTracker.updateTransactionStatus(abortedSequenceId, TxnStatus.ABORTING);
        AssertJUnit.assertEquals((int)0, (int)openMap.size());
        recoverTracker.updateTransactionStatus(abortedSequenceId, TxnStatus.ABORTED);
        field = TransactionRecoverTrackerImpl.class.getDeclaredField("committingTransactions");
        field.setAccessible(true);
        Set commitSet = (Set)field.get(recoverTracker);
        AssertJUnit.assertEquals((int)commitSet.size(), (int)1);
        AssertJUnit.assertTrue((boolean)commitSet.contains(committingSequenceId));
        AssertJUnit.assertFalse((boolean)commitSet.contains(committedSequenceId));
        field = TransactionRecoverTrackerImpl.class.getDeclaredField("abortingTransactions");
        field.setAccessible(true);
        Set abortSet = (Set)field.get(recoverTracker);
        AssertJUnit.assertEquals((int)1, (int)abortSet.size());
        AssertJUnit.assertTrue((boolean)abortSet.contains(abortingSequenceId));
        AssertJUnit.assertFalse((boolean)abortSet.contains(abortedSequenceId));
    }
}

