/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.nio.ByteBuffer;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.common.intercept.InterceptException;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ExceptionHandlerTest {
    @Test
    public void testHandle() {
        String restriction = "Reach the max tenants [5] restriction";
        String internal = "internal exception";
        String illegal = "illegal argument exception ";
        ExceptionHandler handler = new ExceptionHandler();
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        handler.handle((ServletResponse)response, (Exception)new InterceptException(412, restriction));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(412, restriction);
        handler.handle((ServletResponse)response, (Exception)new InterceptException(500, internal));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(500, internal);
        handler.handle((ServletResponse)response, (Exception)new IllegalArgumentException(illegal));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(500, illegal);
        Response response2 = (Response)Mockito.mock(Response.class);
        HttpChannel httpChannel = (HttpChannel)Mockito.mock(HttpChannel.class);
        Mockito.when((Object)response2.getHttpChannel()).thenReturn((Object)httpChannel);
        handler.handle((ServletResponse)response2, (Exception)new InterceptException(412, restriction));
        ((HttpChannel)Mockito.verify((Object)httpChannel)).sendResponse((MetaData.Response)Mockito.any(), (ByteBuffer)Mockito.any(), Mockito.anyBoolean());
    }
}

