/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.web.MaxRequestSizeFilter;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MaxRequestSizeFilterTest {
    private static final long MAX_SIZE = 2L;
    private static final long LEGAL_SIZE = 1L;
    private static final long ILLEGAL_SIZE = 3L;

    @Test
    public void testInChunkedReturnFalse() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        MaxRequestSizeFilter maxRequestSizeFilter = new MaxRequestSizeFilter(2L);
        Method isChunked = maxRequestSizeFilter.getClass().getDeclaredMethod("isChunked", ServletRequest.class);
        isChunked.setAccessible(true);
        ServletRequest mockHttpServletRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        Boolean result = (Boolean)isChunked.invoke((Object)maxRequestSizeFilter, mockHttpServletRequest);
        Assert.assertFalse((boolean)result);
        HttpServletRequest spyHttpServletRequest = (HttpServletRequest)Mockito.spy(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)spyHttpServletRequest)).getHeader("Transfer-Encoding");
        Boolean result2 = (Boolean)isChunked.invoke((Object)maxRequestSizeFilter, spyHttpServletRequest);
        Assert.assertFalse((boolean)result2);
        HttpServletRequest spyHttpServletRequest3 = (HttpServletRequest)Mockito.spy(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"whatever").when((Object)spyHttpServletRequest3)).getHeader("Transfer-Encoding");
        Boolean result3 = (Boolean)isChunked.invoke((Object)maxRequestSizeFilter, spyHttpServletRequest);
        Assert.assertFalse((boolean)result3);
    }

    @Test
    public void testInChunkedReturnTrue() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        MaxRequestSizeFilter maxRequestSizeFilter = new MaxRequestSizeFilter(2L);
        Method isChunked = maxRequestSizeFilter.getClass().getDeclaredMethod("isChunked", ServletRequest.class);
        isChunked.setAccessible(true);
        HttpServletRequest spyHttpServletRequest = (HttpServletRequest)Mockito.spy(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"chunked").when((Object)spyHttpServletRequest)).getHeader("Transfer-Encoding");
        Boolean result = (Boolean)isChunked.invoke((Object)maxRequestSizeFilter, spyHttpServletRequest);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDoFilterSendError() throws ServletException, IOException {
        MaxRequestSizeFilter maxRequestSizeFilter = new MaxRequestSizeFilter(2L);
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        HttpServletRequest spyHttpServletRequest = (HttpServletRequest)Mockito.spy(HttpServletRequest.class);
        HttpServletResponse spyHttpServletResponse = (HttpServletResponse)Mockito.spy(HttpServletResponse.class);
        ((HttpServletRequest)Mockito.doReturn((Object)3L).when((Object)spyHttpServletRequest)).getContentLengthLong();
        maxRequestSizeFilter.doFilter((ServletRequest)spyHttpServletRequest, (ServletResponse)spyHttpServletResponse, mockFilterChain);
        ((HttpServletResponse)Mockito.verify((Object)spyHttpServletResponse)).sendError(400, "Bad Request");
        HttpServletRequest spyHttpServletRequest2 = (HttpServletRequest)Mockito.spy(HttpServletRequest.class);
        HttpServletResponse spyHttpServletResponse2 = (HttpServletResponse)Mockito.spy(HttpServletResponse.class);
        ((HttpServletRequest)Mockito.doReturn((Object)1L).when((Object)spyHttpServletRequest2)).getContentLengthLong();
        ((HttpServletRequest)Mockito.doReturn((Object)"chunked").when((Object)spyHttpServletRequest2)).getHeader("Transfer-Encoding");
        maxRequestSizeFilter.doFilter((ServletRequest)spyHttpServletRequest2, (ServletResponse)spyHttpServletResponse2, mockFilterChain);
        ((HttpServletResponse)Mockito.verify((Object)spyHttpServletResponse)).sendError(400, "Bad Request");
    }

    @Test
    public void testDoFilterInvokeChainDoFilter() throws ServletException, IOException {
        MaxRequestSizeFilter maxRequestSizeFilter = new MaxRequestSizeFilter(2L);
        FilterChain spyFilterChain = (FilterChain)Mockito.spy(FilterChain.class);
        ServletRequest spyHttpServletRequest = (ServletRequest)Mockito.spy(ServletRequest.class);
        ServletResponse spyHttpServletResponse = (ServletResponse)Mockito.spy(ServletResponse.class);
        ((ServletRequest)Mockito.doReturn((Object)1L).when((Object)spyHttpServletRequest)).getContentLengthLong();
        maxRequestSizeFilter.doFilter(spyHttpServletRequest, spyHttpServletResponse, spyFilterChain);
        ((FilterChain)Mockito.verify((Object)spyFilterChain)).doFilter(spyHttpServletRequest, spyHttpServletResponse);
    }
}

