/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web.plugin.servlet;

import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdditionalServletWithClassLoaderTest {
    @Test
    public void testWrapper() {
        AdditionalServlet servlet = (AdditionalServlet)Mockito.mock(AdditionalServlet.class);
        NarClassLoader loader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        AdditionalServletWithClassLoader wrapper = new AdditionalServletWithClassLoader(servlet, loader);
        String basePath = "bathPath";
        Mockito.when((Object)servlet.getBasePath()).thenReturn((Object)basePath);
        Assert.assertEquals((String)basePath, (String)wrapper.getBasePath());
        ((AdditionalServlet)Mockito.verify((Object)servlet, (VerificationMode)Mockito.times((int)1))).getBasePath();
        ServiceConfiguration conf = new ServiceConfiguration();
        wrapper.loadConfig((PulsarConfiguration)conf);
        ((AdditionalServlet)Mockito.verify((Object)servlet, (VerificationMode)Mockito.times((int)1))).loadConfig((PulsarConfiguration)ArgumentMatchers.same((Object)conf));
        Assert.assertEquals((Object)wrapper.getServlet(), (Object)servlet);
        ServletHolder servletHolder = new ServletHolder();
        Mockito.when((Object)servlet.getServletHolder()).thenReturn((Object)servletHolder);
        Assert.assertEquals((Object)wrapper.getServletHolder(), (Object)servletHolder);
        ((AdditionalServlet)Mockito.verify((Object)servlet, (VerificationMode)Mockito.times((int)1))).getServletHolder();
    }

    @Test
    public void testClassLoaderSwitcher() throws Exception {
        final NarClassLoader narLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        AdditionalServlet servlet = new AdditionalServlet(){

            public void loadConfig(PulsarConfiguration pulsarConfiguration) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public String getBasePath() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
                return "base-path";
            }

            public ServletHolder getServletHolder() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
                return null;
            }

            public void close() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }
        };
        AdditionalServletWithClassLoader additionalServletWithClassLoader = new AdditionalServletWithClassLoader(servlet, narLoader);
        ClassLoader curClassLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertEquals((Object)additionalServletWithClassLoader.getClassLoader(), (Object)narLoader);
        Assert.assertEquals((String)additionalServletWithClassLoader.getBasePath(), (String)"base-path");
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        ServiceConfiguration conf = new ServiceConfiguration();
        additionalServletWithClassLoader.loadConfig((PulsarConfiguration)conf);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        Assert.assertNull((Object)additionalServletWithClassLoader.getServletHolder());
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        Assert.assertEquals((Object)additionalServletWithClassLoader.getServlet(), (Object)servlet);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        additionalServletWithClassLoader.close();
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
    }
}

