/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web.plugin.servlet;

import java.io.File;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletDefinition;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletMetadata;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletUtils;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.broker.web.plugin.servlet.MockAdditionalServletWithClassLoader;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.testng.AssertJUnit;
import org.testng.IObjectFactory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(value={NarClassLoader.class})
@PowerMockIgnore(value={"org.apache.logging.log4j.*"})
public class AdditionalServletWithPulsarServiceTest {
    @ObjectFactory
    public IObjectFactory getObjectFactory() {
        return new PowerMockObjectFactory();
    }

    @Test
    public void testLoadAdditionalServlet() throws Exception {
        AdditionalServletDefinition def = new AdditionalServletDefinition();
        def.setAdditionalServletClass(MockAdditionalServletWithClassLoader.class.getName());
        def.setDescription("test-additional-servlet");
        String archivePath = "/path/to/additional/servlet/nar";
        AdditionalServletMetadata metadata = new AdditionalServletMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"additional_servlet.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<MockAdditionalServletWithClassLoader> additionalServletClass = MockAdditionalServletWithClassLoader.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)MockAdditionalServletWithClassLoader.class.getName()))).thenReturn(additionalServletClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        AdditionalServletWithClassLoader returnedASWithCL = AdditionalServletUtils.load((AdditionalServletMetadata)metadata, (String)"");
        AdditionalServlet returnedPh = returnedASWithCL.getServlet();
        AssertJUnit.assertSame((Object)mockLoader, (Object)returnedASWithCL.getClassLoader());
        AssertJUnit.assertTrue((boolean)(returnedPh instanceof MockAdditionalServletWithClassLoader));
    }
}

