/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.zookeeper;

import java.util.List;
import org.apache.pulsar.broker.MultiBrokerBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.metadata.TestZKServer;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class MultiBrokerMetadataConsistencyTest
extends MultiBrokerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MultiBrokerMetadataConsistencyTest.class);
    TestZKServer testZKServer;

    @Override
    protected int numberOfAdditionalBrokers() {
        return 2;
    }

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.testZKServer = new TestZKServer();
    }

    @Override
    protected void onCleanup() {
        super.onCleanup();
        if (this.testZKServer != null) {
            try {
                this.testZKServer.close();
            }
            catch (Exception e) {
                log.error("Error in stopping ZK server", (Throwable)e);
            }
        }
    }

    @Override
    protected MetadataStoreExtended createLocalMetadataStore() throws MetadataStoreException {
        return MetadataStoreExtended.create((String)this.testZKServer.getConnectionString(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
    }

    @Override
    protected MetadataStoreExtended createConfigurationMetadataStore() throws MetadataStoreException {
        return MetadataStoreExtended.create((String)this.testZKServer.getConnectionString(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
    }

    @Test
    public void newTopicShouldBeInTopicsList() throws PulsarAdminException {
        List<PulsarAdmin> admins = this.getAllAdmins();
        PulsarAdmin first = admins.get(0);
        PulsarAdmin second = admins.get(1);
        List cacheMiss = second.topics().getList("public/default");
        Assert.assertTrue((boolean)cacheMiss.isEmpty());
        first.topics().createNonPartitionedTopic("persistent://public/default/my-topic");
        List topics = second.topics().getList("public/default");
        Assert.assertTrue((boolean)topics.contains("persistent://public/default/my-topic"));
    }
}

