/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.authentication.AuthenticationProviderBasic;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.apache.pulsar.common.tls.PublicSuffixMatcher;
import org.apache.pulsar.common.tls.TlsHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class AuthenticationTlsHostnameVerificationTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationTlsHostnameVerificationTest.class);
    private final String TLS_MIM_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/hn-verification/cacert.pem";
    private final String TLS_MIM_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/hn-verification/broker-cert.pem";
    private final String TLS_MIM_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/hn-verification/broker-key.pem";
    private final String TLS_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/cacert.pem";
    private final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/broker-cert.pem";
    private final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/broker-key.pem";
    private final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/authentication/tls/client-cert.pem";
    private final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/authentication/tls/client-key.pem";
    private final String BASIC_CONF_FILE_PATH = "./src/test/resources/authentication/basic/.htpasswd";
    private boolean hostnameVerificationEnabled = true;
    private String clientTrustCertFilePath = "./src/test/resources/authentication/tls/cacert.pem";

    @Override
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        super.stopBroker();
        if (this.methodName.equals("testAnonymousSyncProducerAndConsumer")) {
            this.conf.setAnonymousUserRole("anonymousUser");
        }
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        this.conf.setTlsAllowInsecureConnection(false);
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("localhost");
        superUserRoles.add("superUser");
        superUserRoles.add("superUser2");
        superUserRoles.add("admin");
        this.conf.setSuperUserRoles(superUserRoles);
        this.conf.setBrokerClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.conf.setBrokerClientAuthenticationParameters("tlsCertFile:./src/test/resources/authentication/tls/client-cert.pem,tlsKeyFile:./src/test/resources/authentication/tls/broker-key.pem");
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        providers.add(AuthenticationProviderBasic.class.getName());
        System.setProperty("pulsar.auth.basic.conf", "./src/test/resources/authentication/basic/.htpasswd");
        this.conf.setAuthenticationProviders(providers);
        this.conf.setClusterName("test");
        this.conf.setNumExecutorThreadPoolSize(5);
        this.startBroker();
        this.setupClient();
    }

    protected void setupClient() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        AuthenticationTls authTls = new AuthenticationTls();
        authTls.configure(authParams);
        this.replacePulsarClient(PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrlTls()).statsInterval(0L, TimeUnit.SECONDS).tlsTrustCertsFilePath(this.clientTrustCertFilePath).authentication((Authentication)authTls).enableTls(true).enableTlsHostnameVerification(this.hostnameVerificationEnabled));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        if (!this.methodName.equals("testDefaultHostVerifier")) {
            super.internalCleanup();
        }
    }

    @DataProvider(name="hostnameVerification")
    public Object[][] codecProvider() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test(dataProvider="hostnameVerification")
    public void testTlsSyncProducerAndConsumerWithInvalidBrokerHost(boolean hostnameVerificationEnabled) throws Exception {
        block3: {
            log.info("-- Starting {} test --", (Object)this.methodName);
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.clientTrustCertFilePath = "./src/test/resources/authentication/tls/hn-verification/cacert.pem";
            this.conf.setBrokerServicePortTls(Optional.of(0));
            this.conf.setWebServicePortTls(Optional.of(0));
            this.conf.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
            this.conf.setTlsCertificateFilePath("./src/test/resources/authentication/tls/hn-verification/broker-cert.pem");
            this.conf.setTlsKeyFilePath("./src/test/resources/authentication/tls/hn-verification/broker-key.pem");
            this.conf.setBrokerClientAuthenticationParameters("tlsCertFile:./src/test/resources/authentication/tls/client-cert.pem,tlsKeyFile:./src/test/resources/authentication/tls/hn-verification/broker-key.pem");
            this.setup();
            try {
                this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
                if (hostnameVerificationEnabled) {
                    Assert.fail((String)"Connection should be failed due to hostnameVerification enabled");
                }
            }
            catch (PulsarClientException e) {
                if (hostnameVerificationEnabled) break block3;
                Assert.fail((String)"Consumer should be created because hostnameverification is disabled");
            }
        }
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testTlsSyncProducerAndConsumerCorrectBrokerHost() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.conf.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.conf.setTlsCertificateFilePath("./src/test/resources/authentication/tls/broker-cert.pem");
        this.conf.setTlsKeyFilePath("./src/test/resources/authentication/tls/broker-key.pem");
        this.setup();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns/my-topic").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        Message msg = null;
        HashSet messageSet = Sets.newHashSet();
        for (int i = 0; i < 10; ++i) {
            msg = consumer.receive(5, TimeUnit.SECONDS);
            String receivedMessage = new String(msg.getData());
            log.debug("Received message: [{}]", (Object)receivedMessage);
            String expectedMessage = "my-message-" + i;
            this.testMessageOrderAndDuplicates(messageSet, receivedMessage, expectedMessage);
        }
        consumer.acknowledgeCumulative(msg);
        consumer.close();
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }

    @Test
    public void testDefaultHostVerifier() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        Method matchIdentityStrict = TlsHostnameVerifier.class.getDeclaredMethod("matchIdentityStrict", String.class, String.class, PublicSuffixMatcher.class);
        matchIdentityStrict.setAccessible(true);
        Assert.assertTrue((boolean)((Boolean)matchIdentityStrict.invoke(null, "pulsar", "pulsar", null)));
        Assert.assertFalse((boolean)((Boolean)matchIdentityStrict.invoke(null, "pulsar.com", "pulsar", null)));
        Assert.assertTrue((boolean)((Boolean)matchIdentityStrict.invoke(null, "pulsar-broker1.com", "pulsar*.com", null)));
        Assert.assertFalse((boolean)((Boolean)matchIdentityStrict.invoke(null, "pulsar-broker1.com", "pulsar*com", null)));
        Assert.assertFalse((boolean)((Boolean)matchIdentityStrict.invoke(null, "pulsar.com", "*", null)));
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }
}

