/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.Schema;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class BytesKeyTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    private void byteKeysTest(boolean batching) throws Exception {
        Random r = new Random(0L);
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).enableBatching(batching).batchingMaxPublishDelay(Long.MAX_VALUE, TimeUnit.SECONDS).batchingMaxMessages(Integer.MAX_VALUE).topic("persistent://my-property/my-ns/my-topic1").create();
        byte[] byteKey = new byte[1000];
        r.nextBytes(byteKey);
        producer.newMessage().keyBytes(byteKey).value((Object)"TestMessage").sendAsync();
        producer.flush();
        Message m = consumer.receive();
        Assert.assertEquals((String)((String)m.getValue()), (String)"TestMessage");
        Assert.assertEquals((byte[])m.getKeyBytes(), (byte[])byteKey);
        Assert.assertTrue((boolean)m.hasBase64EncodedKey());
    }

    @Test
    public void testBytesKeyBatch() throws Exception {
        this.byteKeysTest(true);
    }

    @Test
    public void testBytesKeyNoBatch() throws Exception {
        this.byteKeysTest(false);
    }
}

