/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ClientAuthenticationTlsTest
extends ProducerConsumerBase {
    private final String TLS_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/cacert.pem";
    private final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/broker-cert.pem";
    private final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/broker-key.pem";
    private final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/authentication/tls/client-cert.pem";
    private final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/authentication/tls/client-key.pem";
    private final Authentication authenticationTls = new AuthenticationTls("./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem");

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.conf.setClusterName("test");
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setTlsKeyFilePath("./src/test/resources/authentication/tls/broker-key.pem");
        this.conf.setTlsCertificateFilePath("./src/test/resources/authentication/tls/broker-cert.pem");
        this.conf.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.conf.setTlsAllowInsecureConnection(false);
        this.conf.setBrokerClientTlsEnabled(true);
        this.conf.setBrokerClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.conf.setBrokerClientAuthenticationParameters("tlsCertFile:./src/test/resources/authentication/tls/client-cert.pem,tlsKeyFile:./src/test/resources/authentication/tls/client-key.pem");
        this.conf.setBrokerClientTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
    }

    @Override
    @BeforeClass(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
        this.setupDefaultTenantAndNamespace();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Override
    protected void customizeNewPulsarAdminBuilder(PulsarAdminBuilder pulsarAdminBuilder) {
        super.customizeNewPulsarAdminBuilder(pulsarAdminBuilder);
        pulsarAdminBuilder.authentication(this.authenticationTls);
    }

    @Test
    public void testAdminWithTrustCert() throws PulsarClientException, PulsarAdminException {
        PulsarAdmin pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.getPulsar().getWebServiceAddressTls()).sslProvider("JDK").tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").build();
        try {
            pulsarAdmin.clusters().getClusters();
        }
        finally {
            if (Collections.singletonList(pulsarAdmin).get(0) != null) {
                pulsarAdmin.close();
            }
        }
    }

    @Test
    public void testAdminWithFull() throws PulsarClientException, PulsarAdminException {
        PulsarAdmin pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.getPulsar().getWebServiceAddressTls()).sslProvider("JDK").authentication(this.authenticationTls).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").build();
        try {
            pulsarAdmin.clusters().getClusters();
        }
        finally {
            if (Collections.singletonList(pulsarAdmin).get(0) != null) {
                pulsarAdmin.close();
            }
        }
    }

    @Test
    public void testAdminWithCertAndKey() throws PulsarClientException, PulsarAdminException {
        PulsarAdmin pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.getPulsar().getWebServiceAddressTls()).sslProvider("JDK").authentication(this.authenticationTls).build();
        try {
            PulsarAdminException adminException = (PulsarAdminException)Assert.expectThrows(PulsarAdminException.class, () -> pulsarAdmin.clusters().getClusters());
            Assert.assertTrue((boolean)adminException.getMessage().contains("PKIX path"));
        }
        finally {
            if (Collections.singletonList(pulsarAdmin).get(0) != null) {
                pulsarAdmin.close();
            }
        }
    }

    @Test
    public void testAdminWithoutTls() throws PulsarClientException, PulsarAdminException {
        PulsarAdmin pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.getPulsar().getWebServiceAddressTls()).sslProvider("JDK").build();
        try {
            PulsarAdminException adminException = (PulsarAdminException)Assert.expectThrows(PulsarAdminException.class, () -> pulsarAdmin.clusters().getClusters());
            Assert.assertTrue((boolean)adminException.getMessage().contains("PKIX path"));
        }
        finally {
            if (Collections.singletonList(pulsarAdmin).get(0) != null) {
                pulsarAdmin.close();
            }
        }
    }

    @Test
    public void testClientWithTrustCert() throws PulsarClientException, PulsarAdminException {
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsar().getBrokerServiceUrlTls()).sslProvider("JDK").operationTimeout(3, TimeUnit.SECONDS).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").build();
        try {
            Producer ignored = pulsarClient.newProducer().topic(UUID.randomUUID().toString()).create();
            if (Collections.singletonList(ignored).get(0) != null) {
                ignored.close();
            }
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    @Test
    public void testClientWithFull() throws PulsarClientException, PulsarAdminException {
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsar().getBrokerServiceUrlTls()).sslProvider("JDK").operationTimeout(3, TimeUnit.SECONDS).authentication(this.authenticationTls).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").build();
        try {
            Producer ignored = pulsarClient.newProducer().topic(UUID.randomUUID().toString()).create();
            if (Collections.singletonList(ignored).get(0) != null) {
                ignored.close();
            }
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    @Test
    public void testClientWithCertAndKey() throws PulsarClientException {
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsar().getBrokerServiceUrlTls()).sslProvider("JDK").operationTimeout(3, TimeUnit.SECONDS).authentication(this.authenticationTls).build();
        try {
            Assert.assertThrows(PulsarClientException.class, () -> pulsarClient.newProducer().topic(UUID.randomUUID().toString()).create());
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    @Test
    public void testClientWithoutTls() throws PulsarClientException, PulsarAdminException {
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsar().getBrokerServiceUrlTls()).sslProvider("JDK").operationTimeout(3, TimeUnit.SECONDS).build();
        try {
            Assert.assertThrows(PulsarClientException.class, () -> pulsarClient.newProducer().topic(UUID.randomUUID().toString()).create());
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

