/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.broker.authorization.MultiRolesTokenAuthorizationProvider;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MultiRolesTokenAuthorizationProviderTest
extends MockedPulsarServiceBaseTest {
    private final SecretKey secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
    private final String superUserToken;
    private final String normalUserToken;

    public MultiRolesTokenAuthorizationProviderTest() {
        HashMap claims = new HashMap();
        HashSet<String> roles = new HashSet<String>();
        roles.add("user1");
        roles.add("superUser");
        claims.put("roles", roles);
        this.superUserToken = Jwts.builder().setClaims(claims).signWith((Key)this.secretKey).compact();
        roles = new HashSet();
        roles.add("normalUser");
        roles.add("user2");
        roles.add("user5");
        claims.put("roles", roles);
        this.normalUserToken = Jwts.builder().setClaims(claims).signWith((Key)this.secretKey).compact();
    }

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("superUser");
        this.conf.setSuperUserRoles(superUserRoles);
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", "data:;base64," + Base64.getEncoder().encodeToString(this.secretKey.getEncoded()));
        properties.setProperty("tokenAuthClaim", "roles");
        this.conf.setProperties(properties);
        this.conf.setBrokerClientAuthenticationPlugin(AuthenticationToken.class.getName());
        this.conf.setBrokerClientAuthenticationParameters(this.superUserToken);
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderToken.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setAuthorizationProvider(MultiRolesTokenAuthorizationProvider.class.getName());
        this.conf.setClusterName("test");
        this.conf.setNumExecutorThreadPoolSize(5);
    }

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().brokerServiceUrl(this.brokerUrl.toString()).serviceUrl(this.getPulsar().getWebServiceAddress()).build());
    }

    @Override
    @BeforeClass
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Override
    protected void customizeNewPulsarClientBuilder(ClientBuilder clientBuilder) {
        clientBuilder.authentication((Authentication)new AuthenticationToken(this.superUserToken));
    }

    @Override
    protected void customizeNewPulsarAdminBuilder(PulsarAdminBuilder pulsarAdminBuilder) {
        pulsarAdminBuilder.authentication((Authentication)new AuthenticationToken(this.superUserToken));
    }

    private PulsarAdmin newPulsarAdmin(String token) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(this.pulsar.getWebServiceAddress()).authentication((Authentication)new AuthenticationToken(token)).requestTimeout(3, TimeUnit.SECONDS).build();
    }

    private PulsarClient newPulsarClient(String token) throws PulsarClientException {
        return PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new AuthenticationToken(token)).operationTimeout(3, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminRequestWithSuperUserToken() throws Exception {
        String tenant = "superuser-admin-tenant";
        PulsarAdmin admin = this.newPulsarAdmin(this.superUserToken);
        try {
            admin.tenants().createTenant(tenant, TenantInfo.builder().allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"test"})).build());
            String namespace = "superuser-admin-namespace";
            admin.namespaces().createNamespace(tenant + "/" + namespace);
            admin.brokers().getAllDynamicConfigurations();
            admin.tenants().getTenants();
            admin.topics().getList(tenant + "/" + namespace);
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProduceAndConsumeWithSuperUserToken() throws Exception {
        String tenant = "superuser-client-tenant";
        PulsarAdmin admin = this.newPulsarAdmin(this.superUserToken);
        try {
            admin.tenants().createTenant(tenant, TenantInfo.builder().allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"test"})).build());
            String namespace = "superuser-client-namespace";
            admin.namespaces().createNamespace(tenant + "/" + namespace);
            String topic = tenant + "/" + namespace + "/test-topic";
            PulsarClient client = this.newPulsarClient(this.superUserToken);
            try {
                Producer producer = client.newProducer().topic(topic).create();
                try {
                    byte[] body = "hello".getBytes(StandardCharsets.UTF_8);
                    producer.send((Object)body);
                    Consumer consumer = client.newConsumer().topic(new String[]{topic}).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("test").subscribe();
                    try {
                        Message message = consumer.receive(3, TimeUnit.SECONDS);
                        Assert.assertNotNull((Object)message);
                        Assert.assertEquals((byte[])message.getData(), (byte[])body);
                    }
                    finally {
                        if (Collections.singletonList(consumer).get(0) != null) {
                            consumer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    @Test
    public void testAdminRequestWithNormalUserToken() throws Exception {
        String tenant = "normaluser-admin-tenant";
        PulsarAdmin admin = this.newPulsarAdmin(this.normalUserToken);
        try {
            Assert.assertThrows(PulsarAdminException.NotAuthorizedException.class, () -> admin.tenants().createTenant(tenant, TenantInfo.builder().allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"test"})).build()));
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProduceAndConsumeWithNormalUserToken() throws Exception {
        String tenant = "normaluser-client-tenant";
        PulsarAdmin admin = this.newPulsarAdmin(this.superUserToken);
        try {
            admin.tenants().createTenant(tenant, TenantInfo.builder().allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"test"})).build());
            String namespace = "normaluser-client-namespace";
            admin.namespaces().createNamespace(tenant + "/" + namespace);
            String topic = tenant + "/" + namespace + "/test-topic";
            PulsarClient client = this.newPulsarClient(this.normalUserToken);
            try {
                Assert.assertThrows(PulsarClientException.AuthorizationException.class, () -> {
                    Producer ignored = client.newProducer().topic(topic).create();
                    if (Collections.singletonList(ignored).get(0) != null) {
                        ignored.close();
                    }
                });
                Assert.assertThrows(PulsarClientException.AuthorizationException.class, () -> {
                    Consumer ignored = client.newConsumer().topic(new String[]{topic}).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("test").subscribe();
                    if (Collections.singletonList(ignored).get(0) != null) {
                        ignored.close();
                    }
                });
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }
}

