/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ProducerCreationTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="topicDomainProvider")
    public Object[][] topicDomainProvider() {
        return new Object[][]{{TopicDomain.persistent}, {TopicDomain.non_persistent}};
    }

    @Test(dataProvider="topicDomainProvider")
    public void testExactlyOnceWithProducerNameSpecified(TopicDomain domain) throws PulsarClientException {
        Producer producer1 = this.pulsarClient.newProducer().topic(TopicName.get((String)domain.value(), (String)"public", (String)"default", (String)"testExactlyOnceWithProducerNameSpecified").toString()).producerName("p-name-1").create();
        Assert.assertNotNull((Object)producer1);
        Producer producer2 = this.pulsarClient.newProducer().topic("testExactlyOnceWithProducerNameSpecified").producerName("p-name-2").create();
        Assert.assertNotNull((Object)producer2);
        try {
            this.pulsarClient.newProducer().topic("testExactlyOnceWithProducerNameSpecified").producerName("p-name-2").create();
            Assert.fail((String)"should be failed");
        }
        catch (PulsarClientException.ProducerBusyException producerBusyException) {
            // empty catch block
        }
    }

    @Test(dataProvider="topicDomainProvider")
    public void testGeneratedNameProducerReconnect(TopicDomain domain) throws PulsarClientException, InterruptedException {
        ProducerImpl producer = (ProducerImpl)this.pulsarClient.newProducer().topic(TopicName.get((String)domain.value(), (String)"public", (String)"default", (String)"testGeneratedNameProducerReconnect").toString()).create();
        Assert.assertTrue((boolean)producer.isConnected());
        Thread.sleep(3000L);
        producer.getConnectionHandler().connectionClosed(producer.getConnectionHandler().cnx());
        Assert.assertFalse((boolean)producer.isConnected());
        Thread.sleep(3000L);
        Assert.assertEquals((long)producer.getConnectionHandler().getEpoch(), (long)1L);
        Assert.assertTrue((boolean)producer.isConnected());
    }
}

