/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.impl.BinaryProtoLookupService;
import org.apache.pulsar.client.impl.HttpLookupService;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class PulsarMultiListenersWithInternalListenerNameTest
extends MockedPulsarServiceBaseTest {
    private final boolean withInternalListener;
    private ExecutorService executorService;
    private String hostAndBrokerPort;
    private String hostAndBrokerPortSsl;
    private EventLoopGroup eventExecutors;

    public PulsarMultiListenersWithInternalListenerNameTest() {
        this(true);
    }

    protected PulsarMultiListenersWithInternalListenerNameTest(boolean withInternalListener) {
        this.withInternalListener = withInternalListener;
        this.enableBrokerGateway = true;
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.executorService = Executors.newFixedThreadPool(1);
        this.eventExecutors = new NioEventLoopGroup();
        this.isTcpLookup = true;
        String host = InetAddress.getLocalHost().getHostAddress();
        int brokerPort = PulsarMultiListenersWithInternalListenerNameTest.getFreePort();
        this.hostAndBrokerPort = host + ":" + brokerPort;
        int brokerPortSsl = PulsarMultiListenersWithInternalListenerNameTest.getFreePort();
        this.hostAndBrokerPortSsl = host + ":" + brokerPortSsl;
        super.internalSetup();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFreePort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.conf.setClusterName("localhost");
        this.conf.setAdvertisedListeners(String.format("internal:pulsar://%s,internal:pulsar+ssl://%s", this.hostAndBrokerPort, this.hostAndBrokerPortSsl));
        if (this.withInternalListener) {
            this.conf.setInternalListenerName("internal");
        }
    }

    @Override
    protected void customizeNewPulsarClientBuilder(ClientBuilder clientBuilder) {
        clientBuilder.listenerName("internal");
    }

    @Test
    public void testFindBrokerWithListenerName() throws Exception {
        this.admin.clusters().createCluster("localhost", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfo tenantInfo = TenantInfo.builder().allowedClusters(Collections.singleton("localhost")).build();
        this.admin.tenants().createTenant("public", tenantInfo);
        this.admin.namespaces().createNamespace("public/default");
        this.doFindBrokerWithListenerName(true);
        this.doFindBrokerWithListenerName(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFindBrokerWithListenerName(boolean useHttp) throws Exception {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setListenerName("internal");
        conf.setServiceUrl(this.pulsar.getWebServiceAddress());
        conf.setMaxLookupRedirects(10);
        HttpLookupService lookupService = useHttp ? new HttpLookupService(conf, this.eventExecutors) : new BinaryProtoLookupService((PulsarClientImpl)this.pulsarClient, this.lookupUrl.toString(), "internal", false, this.executorService);
        try {
            CompletableFuture future = lookupService.getBroker(TopicName.get((String)"persistent://public/default/test"));
            Pair result = (Pair)future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)((InetSocketAddress)result.getKey()).toString(), (String)this.hostAndBrokerPort);
            Assert.assertEquals((String)((InetSocketAddress)result.getValue()).toString(), (String)this.hostAndBrokerPort);
            future = lookupService.getBroker(TopicName.get((String)"persistent://public/default/test"));
            result = (Pair)future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)((InetSocketAddress)result.getKey()).toString(), (String)this.hostAndBrokerPort);
            Assert.assertEquals((String)((InetSocketAddress)result.getValue()).toString(), (String)this.hostAndBrokerPort);
        }
        finally {
            if (Collections.singletonList(lookupService).get(0) != null) {
                lookupService.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpLookupRedirect() throws Exception {
        this.admin.clusters().createCluster("localhost", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfo tenantInfo = TenantInfo.builder().allowedClusters(Collections.singleton("localhost")).build();
        this.admin.tenants().createTenant("public", tenantInfo);
        this.admin.namespaces().createNamespace("public/default");
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setListenerName("internal");
        conf.setServiceUrl(this.pulsar.getWebServiceAddress());
        conf.setMaxLookupRedirects(10);
        HttpLookupService lookupService = new HttpLookupService(conf, this.eventExecutors);
        try {
            NamespaceService namespaceService = this.pulsar.getNamespaceService();
            LookupResult lookupResult = new LookupResult(this.pulsar.getWebServiceAddress(), null, this.pulsar.getBrokerServiceUrl(), null, true);
            Optional<LookupResult> optional = Optional.of(lookupResult);
            String address = "192.168.0.1:8080";
            String httpAddress = "192.168.0.1:8081";
            NamespaceEphemeralData namespaceEphemeralData = new NamespaceEphemeralData("pulsar://" + address, null, "http://" + httpAddress, null, false);
            LookupResult lookupResult2 = new LookupResult(namespaceEphemeralData);
            Optional<LookupResult> optional2 = Optional.of(lookupResult2);
            ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(optional), (Object[])new Object[]{CompletableFuture.completedFuture(optional2)}).when((Object)namespaceService)).getBrokerServiceUrlAsync((TopicName)ArgumentMatchers.any(), (LookupOptions)ArgumentMatchers.any());
            CompletableFuture future = lookupService.getBroker(TopicName.get((String)"persistent://public/default/test"));
            Pair result = (Pair)future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)((InetSocketAddress)result.getKey()).toString(), (String)address);
            Assert.assertEquals((String)((InetSocketAddress)result.getValue()).toString(), (String)address);
        }
        finally {
            if (Collections.singletonList(lookupService).get(0) != null) {
                lookupService.close();
            }
        }
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.eventExecutors != null) {
            this.eventExecutors.shutdownGracefully();
        }
        super.internalCleanup();
    }
}

