/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ServiceUrlProviderTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(ServiceUrlProviderTest.class);

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateClientWithServiceUrlProvider() throws Exception {
        PulsarClient client = PulsarClient.builder().serviceUrlProvider((ServiceUrlProvider)new TestServiceUrlProvider(this.pulsar.getBrokerServiceUrl())).statsInterval(1L, TimeUnit.SECONDS).build();
        try {
            int i;
            Assert.assertTrue((boolean)(((PulsarClientImpl)client).getConfiguration().getServiceUrlProvider() instanceof TestServiceUrlProvider));
            Producer producer = client.newProducer(Schema.STRING).topic("persistent://my-property/my-ns/my-topic").create();
            Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscribe").subscribe();
            for (i = 0; i < 100; ++i) {
                producer.send((Object)("Hello Pulsar[" + i + "]"));
            }
            client.updateServiceUrl(this.pulsar.getBrokerServiceUrl());
            for (i = 100; i < 200; ++i) {
                producer.send((Object)("Hello Pulsar[" + i + "]"));
            }
            int received = 0;
            do {
                Message message = consumer.receive();
                System.out.println((String)message.getValue());
            } while (++received < 200);
            Assert.assertEquals((int)received, (int)200);
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateClientWithAutoChangedServiceUrlProvider() throws Exception {
        AutoChangedServiceUrlProvider serviceUrlProvider = new AutoChangedServiceUrlProvider(this.pulsar.getBrokerServiceUrl());
        PulsarClient client = PulsarClient.builder().serviceUrlProvider((ServiceUrlProvider)serviceUrlProvider).statsInterval(1L, TimeUnit.SECONDS).build();
        try {
            Assert.assertTrue((boolean)(((PulsarClientImpl)client).getConfiguration().getServiceUrlProvider() instanceof AutoChangedServiceUrlProvider));
            ProducerImpl producer = (ProducerImpl)client.newProducer(Schema.STRING).topic("persistent://my-property/my-ns/my-topic").create();
            ConsumerImpl consumer = (ConsumerImpl)client.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscribe").subscribe();
            PulsarService pulsarService1 = this.pulsar;
            this.conf.setBrokerShutdownTimeoutMs(0L);
            this.conf.setBrokerServicePort(Optional.of(0));
            this.conf.setWebServicePort(Optional.of(0));
            this.restartBroker();
            PulsarService pulsarService2 = this.pulsar;
            log.info("Pulsar1 = {}, Pulsar2 = {}", (Object)pulsarService1.getBrokerServiceUrl(), (Object)pulsarService2.getBrokerServiceUrl());
            Assert.assertNotEquals((Object)pulsarService1.getBrokerServiceUrl(), (Object)pulsarService2.getBrokerServiceUrl());
            log.info("Service url : producer = {}, consumer = {}", (Object)producer.getClient().getLookup().getServiceUrl(), (Object)consumer.getClient().getLookup().getServiceUrl());
            Assert.assertEquals((String)producer.getClient().getLookup().getServiceUrl(), (String)pulsarService1.getBrokerServiceUrl());
            Assert.assertEquals((String)consumer.getClient().getLookup().getServiceUrl(), (String)pulsarService1.getBrokerServiceUrl());
            log.info("Changing service url from {} to {}", (Object)pulsarService1.getBrokerServiceUrl(), (Object)pulsarService2.getBrokerServiceUrl());
            serviceUrlProvider.onServiceUrlChanged(pulsarService2.getBrokerServiceUrl());
            log.info("Service url changed : producer = {}, consumer = {}", (Object)producer.getClient().getLookup().getServiceUrl(), (Object)consumer.getClient().getLookup().getServiceUrl());
            Assert.assertEquals((String)producer.getClient().getLookup().getServiceUrl(), (String)pulsarService2.getBrokerServiceUrl());
            Assert.assertEquals((String)consumer.getClient().getLookup().getServiceUrl(), (String)pulsarService2.getBrokerServiceUrl());
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    static class AutoChangedServiceUrlProvider
    extends TestServiceUrlProvider {
        public AutoChangedServiceUrlProvider(String serviceUrl) {
            super(serviceUrl);
        }

        public void onServiceUrlChanged(String newServiceUrl) throws PulsarClientException {
            this.getPulsarClient().updateServiceUrl(newServiceUrl);
        }
    }

    static class TestServiceUrlProvider
    implements ServiceUrlProvider {
        private PulsarClient pulsarClient;
        private final String serviceUrl;

        public TestServiceUrlProvider(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void initialize(PulsarClient client) {
            this.pulsarClient = client;
        }

        public PulsarClient getPulsarClient() {
            return this.pulsarClient;
        }
    }
}

