/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.BinaryProtoLookupService;
import org.apache.pulsar.client.impl.HttpLookupService;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.reader.AvroReader;
import org.apache.pulsar.client.impl.schema.writer.AvroWriter;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class SimpleSchemaTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(SimpleSchemaTest.class);
    private final boolean schemaValidationEnforced;

    @DataProvider(name="batchingModes")
    public static Object[][] batchingModes() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="batchingModesAndValueEncodingType")
    public static Object[][] batchingModesAndValueEncodingType() {
        return new Object[][]{{true, KeyValueEncodingType.INLINE}, {true, KeyValueEncodingType.SEPARATED}, {false, KeyValueEncodingType.INLINE}, {false, KeyValueEncodingType.SEPARATED}};
    }

    @DataProvider(name="schemaValidationModes")
    public static Object[][] schemaValidationModes() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="topicDomain")
    public static Object[] topicDomain() {
        return new Object[]{"persistent://", "non-persistent://"};
    }

    @Factory(dataProvider="schemaValidationModes")
    public SimpleSchemaTest(boolean schemaValidationEnforced) {
        this.schemaValidationEnforced = schemaValidationEnforced;
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setSchemaValidationEnforced(this.schemaValidationEnforced);
        this.isTcpLookup = true;
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testString() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
             Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://my-property/my-ns/my-topic1").create();){
            int i;
            int N = 10;
            for (i = 0; i < N; ++i) {
                producer.send((Object)("my-message-" + i));
            }
            for (i = 0; i < N; ++i) {
                Message msg = consumer.receive();
                Assert.assertEquals((String)((String)msg.getValue()), (String)("my-message-" + i));
                consumer.acknowledge(msg);
            }
        }
    }

    @Test
    public void newProducerNewTopicNewSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(0));
        }
    }

    @Test
    public void newProducerTopicExistsWithoutSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();){
            p.send((Object)topic.getBytes(StandardCharsets.UTF_8));
        }
        p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
        var3_3 = null;
        try {
            p.send((Object)new V1Data(0));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var3_3 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    @Test
    public void newProducerTopicExistsWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(1));
        }
        p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
        var3_3 = null;
        try {
            p.send((Object)new V1Data(0));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var3_3 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
    }

    @Test
    public void newProducerWithoutSchemaOnTopicWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            p.send((Object)new V1Data(0));
        }
        try {
            p = this.pulsarClient.newProducer(Schema.BYTES).topic(topic).create();
            var3_5 = null;
            try {
                if (!this.schemaValidationEnforced) {
                    p.send((Object)"junkdata".getBytes(StandardCharsets.UTF_8));
                } else {
                    Assert.fail((String)"Shouldn't be able to connect to a schema'd topic with no schema if SchemaValidationEnabled is enabled");
                }
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var3_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            if (this.schemaValidationEnforced) {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
            }
            Assert.fail((String)"Shouldn't throw IncompatibleSchemaException if SchemaValidationEnforced is disabled");
        }
        try {
            p = this.pulsarClient.newProducer(Schema.AUTO_PRODUCE_BYTES()).topic(topic).create();
            var3_5 = null;
            try {
                p.send((Object)"junkdata".getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
            finally {
                if (p != null) {
                    if (var3_5 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SchemaSerializationException));
        }
        Schema v1Schema = Schema.AVRO(V1Data.class);
        byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
        org.apache.avro.Schema v1SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes));
        try (Producer p = this.pulsarClient.newProducer(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).topic(topic).create();){
            p.send((Object)"junkdata".getBytes(StandardCharsets.UTF_8));
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SchemaSerializationException));
        }
    }

    @Test
    public void newProducerForMessageSchemaOnTopicWithMultiVersionSchema() throws Exception {
        block48: {
            String topic = "my-property/my-ns/schema-test";
            Schema v1Schema = Schema.AVRO(V1Data.class);
            byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
            AvroWriter v1Writer = new AvroWriter(new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes)));
            Schema v2Schema = Schema.AVRO(V2Data.class);
            byte[] v2SchemaBytes = v2Schema.getSchemaInfo().getSchema();
            AvroWriter v2Writer = new AvroWriter(new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v2SchemaBytes)));
            Producer ignored = this.pulsarClient.newProducer(v1Schema).topic(topic).create();
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
            throwable = null;
            try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic(topic).create();){
                p.send((Object)new V2Data(-1, -1));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            V1Data dataV1 = new V1Data(2);
            V2Data dataV2 = new V2Data(3, 5);
            byte[] contentV1 = v1Writer.write((Object)dataV1);
            byte[] contentV2 = v2Writer.write((Object)dataV2);
            try (Producer p = this.pulsarClient.newProducer(Schema.AUTO_PRODUCE_BYTES()).topic(topic).create();
                 Consumer c = this.pulsarClient.newConsumer(v2Schema).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
                Assert.expectThrows(SchemaSerializationException.class, () -> p.send((Object)contentV1));
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)Schema.AVRO(V1Data.class))).value((Object)contentV1).send();
                p.send((Object)contentV2);
                Message msg1 = c.receive();
                V2Data msg1Value = (V2Data)msg1.getValue();
                Assert.assertEquals((int)dataV1.i, (int)msg1Value.i);
                Assert.assertNull((Object)msg1Value.j);
                Assert.assertEquals((byte[])msg1.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
                Message msg2 = c.receive();
                Assert.assertEquals((Object)dataV2, (Object)msg2.getValue());
                Assert.assertEquals((byte[])msg2.getSchemaVersion(), (byte[])new LongSchemaVersion(1L).bytes());
                try {
                    p.newMessage(Schema.BYTES).value((Object)contentV1).send();
                    if (this.schemaValidationEnforced) {
                        Assert.fail((String)"Shouldn't be able to send to a schema'd topic with no schema if SchemaValidationEnabled is enabled");
                    }
                    Message msg3 = c.receive();
                    Assert.assertNull((Object)msg3.getSchemaVersion());
                    try {
                        msg3.getValue();
                        Assert.fail((String)"Schema should be incompatible");
                    }
                    catch (SchemaSerializationException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof EOFException));
                    }
                }
                catch (PulsarClientException e) {
                    if (this.schemaValidationEnforced) {
                        Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
                        break block48;
                    }
                    Assert.fail((String)"Shouldn't throw IncompatibleSchemaException if SchemaValidationEnforced is disabled");
                }
            }
        }
    }

    @Test
    public void newNativeAvroProducerForMessageSchemaOnTopicWithMultiVersionSchema() throws Exception {
        block48: {
            String topic = "my-property/my-ns/schema-test";
            Schema v1Schema = Schema.AVRO(V1Data.class);
            byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
            org.apache.avro.Schema v1SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes));
            AvroWriter v1Writer = new AvroWriter(v1SchemaAvroNative);
            Schema v2Schema = Schema.AVRO(V2Data.class);
            byte[] v2SchemaBytes = v2Schema.getSchemaInfo().getSchema();
            org.apache.avro.Schema v2SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v2SchemaBytes));
            AvroWriter v2Writer = new AvroWriter(v2SchemaAvroNative);
            V1Data dataV1 = new V1Data(2);
            V2Data dataV2 = new V2Data(3, 5);
            byte[] contentV1 = v1Writer.write((Object)dataV1);
            byte[] contentV2 = v2Writer.write((Object)dataV2);
            Producer ignored = this.pulsarClient.newProducer(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).topic(topic).create();
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
            throwable = null;
            try (Producer p = this.pulsarClient.newProducer(Schema.NATIVE_AVRO((Object)v2SchemaAvroNative)).topic(topic).create();){
                p.send((Object)contentV2);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            p = this.pulsarClient.newProducer(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).topic(topic).create();
            throwable = null;
            try (Consumer c = this.pulsarClient.newConsumer(v2Schema).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
                p.newMessage(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).value((Object)contentV1).send();
                p.newMessage(Schema.NATIVE_AVRO((Object)v2SchemaAvroNative)).value((Object)contentV2).send();
                Message msg1 = c.receive();
                V2Data msg1Value = (V2Data)msg1.getValue();
                Assert.assertEquals((int)dataV1.i, (int)msg1Value.i);
                Assert.assertNull((Object)msg1Value.j);
                Assert.assertEquals((byte[])msg1.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
                Message msg2 = c.receive();
                Assert.assertEquals((Object)dataV2, (Object)msg2.getValue());
                Assert.assertEquals((byte[])msg2.getSchemaVersion(), (byte[])new LongSchemaVersion(1L).bytes());
                try {
                    p.newMessage(Schema.BYTES).value((Object)contentV1).send();
                    if (this.schemaValidationEnforced) {
                        Assert.fail((String)"Shouldn't be able to send to a schema'd topic with no schema if SchemaValidationEnabled is enabled");
                    }
                    Message msg3 = c.receive();
                    Assert.assertNull((Object)msg3.getSchemaVersion());
                    try {
                        msg3.getValue();
                        Assert.fail((String)"Schema should be incompatible");
                    }
                    catch (SchemaSerializationException e) {
                        Assert.assertTrue((boolean)(e.getCause() instanceof EOFException));
                    }
                }
                catch (PulsarClientException e) {
                    if (this.schemaValidationEnforced) {
                        Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
                        break block48;
                    }
                    Assert.fail((String)"Shouldn't throw IncompatibleSchemaException if SchemaValidationEnforced is disabled");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (p != null) {
                    if (throwable != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
    }

    @Test
    public void newProducerForMessageOnTopicWithDifferentSchemaType() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        V1Data data1 = new V1Data(2);
        V2Data data2 = new V2Data(3, 5);
        V1Data data3 = new V1Data(8);
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V2Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            p.newMessage().value((Object)data1).send();
            p.newMessage(Schema.AVRO(V2Data.class)).value((Object)data2).send();
            p.newMessage(Schema.AVRO(V1Data.class)).value((Object)data3).send();
            Message msg1 = c.receive();
            V2Data msg1Value = (V2Data)msg1.getValue();
            Assert.assertEquals((int)data1.i, (int)msg1Value.i);
            Assert.assertNull((Object)msg1Value.j);
            Assert.assertEquals((byte[])msg1.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
            Message msg2 = c.receive();
            Assert.assertEquals((Object)data2, (Object)msg2.getValue());
            Assert.assertEquals((byte[])msg2.getSchemaVersion(), (byte[])new LongSchemaVersion(1L).bytes());
            Message msg3 = c.receive();
            V2Data msg3Value = (V2Data)msg3.getValue();
            Assert.assertEquals((int)data3.i, (int)msg3Value.i);
            Assert.assertNull((Object)msg3Value.j);
            Assert.assertEquals((byte[])msg3.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
        }
    }

    @Test
    public void newProducerForMessageSchemaOnTopicInitialWithNoSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        Schema v1Schema = Schema.AVRO(V1Data.class);
        byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
        AvroWriter v1Writer = new AvroWriter(new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes)));
        Schema v2Schema = Schema.AVRO(V2Data.class);
        byte[] v2SchemaBytes = v2Schema.getSchemaInfo().getSchema();
        AvroWriter v2Writer = new AvroWriter(new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v2SchemaBytes)));
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            for (int i = 0; i < 2; ++i) {
                V1Data dataV1 = new V1Data(i);
                V2Data dataV2 = new V2Data(i, -i);
                byte[] contentV1 = v1Writer.write((Object)dataV1);
                byte[] contentV2 = v2Writer.write((Object)dataV2);
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)v1Schema)).value((Object)contentV1).send();
                Message msg1 = c.receive();
                Assert.assertEquals((byte[])msg1.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
                Assert.assertEquals((byte[])msg1.getData(), (byte[])contentV1);
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)v2Schema)).value((Object)contentV2).send();
                Message msg2 = c.receive();
                Assert.assertEquals((byte[])msg2.getSchemaVersion(), (byte[])new LongSchemaVersion(1L).bytes());
                Assert.assertEquals((byte[])msg2.getData(), (byte[])contentV2);
            }
        }
        List allSchemas = this.admin.schemas().getAllSchemas(topic);
        allSchemas.forEach(schemaInfo -> ((SchemaInfoImpl)schemaInfo).setTimestamp(0L));
        Assert.assertEquals((Collection)allSchemas, Arrays.asList(v1Schema.getSchemaInfo(), v2Schema.getSchemaInfo()));
    }

    @Test
    public void newNativeAvroProducerForMessageSchemaOnTopicInitialWithNoSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        Schema v1Schema = Schema.AVRO(V1Data.class);
        byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
        org.apache.avro.Schema v1SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes));
        AvroWriter v1Writer = new AvroWriter(v1SchemaAvroNative);
        Schema v2Schema = Schema.AVRO(V2Data.class);
        byte[] v2SchemaBytes = v2Schema.getSchemaInfo().getSchema();
        org.apache.avro.Schema v2SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v2SchemaBytes));
        AvroWriter v2Writer = new AvroWriter(v2SchemaAvroNative);
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            for (int i = 0; i < 2; ++i) {
                V1Data dataV1 = new V1Data(i);
                V2Data dataV2 = new V2Data(i, -i);
                byte[] contentV1 = v1Writer.write((Object)dataV1);
                byte[] contentV2 = v2Writer.write((Object)dataV2);
                p.newMessage(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).value((Object)contentV1).send();
                Message msg1 = c.receive();
                Assert.assertEquals((byte[])msg1.getSchemaVersion(), (byte[])new LongSchemaVersion(0L).bytes());
                Assert.assertEquals((byte[])msg1.getData(), (byte[])contentV1);
                p.newMessage(Schema.NATIVE_AVRO((Object)v2SchemaAvroNative)).value((Object)contentV2).send();
                Message msg2 = c.receive();
                Assert.assertEquals((byte[])msg2.getSchemaVersion(), (byte[])new LongSchemaVersion(1L).bytes());
                Assert.assertEquals((byte[])msg2.getData(), (byte[])contentV2);
            }
        }
        List allSchemas = this.admin.schemas().getAllSchemas(topic);
        allSchemas.forEach(schemaInfo -> ((SchemaInfoImpl)schemaInfo).setTimestamp(0L));
        Assert.assertEquals((Collection)allSchemas, Arrays.asList(v1Schema.getSchemaInfo(), v2Schema.getSchemaInfo()));
    }

    @Test
    public void newProducerForMessageSchemaWithBatch() throws Exception {
        int i;
        String topic = "my-property/my-ns/schema-test";
        Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V2Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();
        Producer p = this.pulsarClient.newProducer(Schema.AUTO_PRODUCE_BYTES()).topic(topic).enableBatching(true).batchingMaxPublishDelay(10L, TimeUnit.SECONDS).create();
        AvroWriter v1DataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(V1Data.class));
        AvroWriter v2DataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(V2Data.class));
        AvroWriter incompatibleDataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(IncompatibleData.class));
        int total = 20;
        int batch = 5;
        int incompatible = 3;
        for (i = 0; i < total; ++i) {
            byte[] content;
            if (i / batch % 2 == 0) {
                content = v1DataAvroWriter.write((Object)new V1Data(i));
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)Schema.AVRO(V1Data.class))).value((Object)content).sendAsync();
            } else {
                content = v2DataAvroWriter.write((Object)new V2Data(i, i + total));
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)Schema.AVRO(V2Data.class))).value((Object)content).sendAsync();
            }
            if ((i + 1) % incompatible != 0) continue;
            content = incompatibleDataAvroWriter.write((Object)new IncompatibleData(-i, -i));
            try {
                p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)Schema.AVRO(IncompatibleData.class))).value((Object)content).send();
                continue;
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException), (String)e.getMessage());
            }
        }
        p.flush();
        for (i = 0; i < total; ++i) {
            V2Data value = (V2Data)c.receive().getValue();
            if (i / batch % 2 == 0) {
                Assert.assertNull((Object)value.j);
                Assert.assertEquals((int)value.i, (int)i);
                continue;
            }
            Assert.assertEquals((Object)value, (Object)new V2Data(i, i + total));
        }
        c.close();
    }

    @Test
    public void newNativeAvroProducerForMessageSchemaWithBatch() throws Exception {
        int i;
        String topic = "my-property/my-ns/schema-test";
        Schema v1Schema = Schema.AVRO(V1Data.class);
        byte[] v1SchemaBytes = v1Schema.getSchemaInfo().getSchema();
        org.apache.avro.Schema v1SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v1SchemaBytes));
        AvroWriter v1Writer = new AvroWriter(v1SchemaAvroNative);
        Schema v2Schema = Schema.AVRO(V2Data.class);
        byte[] v2SchemaBytes = v2Schema.getSchemaInfo().getSchema();
        org.apache.avro.Schema v2SchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(v2SchemaBytes));
        AvroWriter v2Writer = new AvroWriter(v2SchemaAvroNative);
        Consumer c = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{topic}).subscriptionName("sub1").subscribe();
        Producer p = this.pulsarClient.newProducer(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).topic(topic).enableBatching(true).batchingMaxPublishDelay(10L, TimeUnit.SECONDS).create();
        AvroWriter v1DataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(V1Data.class));
        AvroWriter v2DataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(V2Data.class));
        AvroWriter incompatibleDataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(IncompatibleData.class));
        int total = 20;
        int batch = 5;
        int incompatible = 3;
        for (i = 0; i < total; ++i) {
            byte[] content;
            if (i / batch % 2 == 0) {
                content = v1DataAvroWriter.write((Object)new V1Data(i));
                p.newMessage(Schema.NATIVE_AVRO((Object)v1SchemaAvroNative)).value((Object)content).sendAsync();
            } else {
                content = v2DataAvroWriter.write((Object)new V2Data(i, i + total));
                p.newMessage(Schema.NATIVE_AVRO((Object)v2SchemaAvroNative)).value((Object)content).sendAsync();
            }
            if ((i + 1) % incompatible != 0) continue;
            Schema incompatibleSchema = Schema.AVRO(IncompatibleData.class);
            byte[] incompatibleSchemaBytes = incompatibleSchema.getSchemaInfo().getSchema();
            org.apache.avro.Schema incompatibleSchemaAvroNative = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(incompatibleSchemaBytes));
            byte[] content2 = incompatibleDataAvroWriter.write((Object)new IncompatibleData(-i, -i));
            try {
                p.newMessage(Schema.NATIVE_AVRO((Object)incompatibleSchemaAvroNative)).value((Object)content2).send();
                continue;
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException), (String)e.getMessage());
            }
        }
        p.flush();
        for (i = 0; i < total; ++i) {
            Object value;
            AvroReader reader;
            byte[] raw = c.receive().getData();
            if (i / batch % 2 == 0) {
                reader = new AvroReader(v1SchemaAvroNative);
                value = (V1Data)reader.read(raw);
                Assert.assertEquals((int)((V1Data)value).i, (int)i);
                continue;
            }
            reader = new AvroReader(v2SchemaAvroNative);
            value = (V2Data)reader.read(raw);
            Assert.assertEquals((Object)value, (Object)new V2Data(i, i + total));
        }
        c.close();
    }

    @Test
    public void newProducerWithMultipleSchemaDisabled() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        AvroWriter v1DataAvroWriter = new AvroWriter(ReflectData.AllowNull.get().getSchema(V1Data.class));
        try (Producer p = this.pulsarClient.newProducer().topic(topic).enableMultiSchema(false).create();){
            Assert.assertThrows(PulsarClientException.InvalidMessageException.class, () -> p.newMessage(Schema.AUTO_PRODUCE_BYTES((Schema)Schema.AVRO(V1Data.class))).value((Object)v1DataAvroWriter.write((Object)new V1Data(0))).send());
        }
    }

    @Test
    public void newConsumerWithSchemaOnNewTopic() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();
             Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();){
            V1Data toSend = new V1Data(1);
            p.send((Object)toSend);
            Assert.assertEquals((Object)toSend, (Object)c.receive().getValue());
        }
    }

    @Test
    public void newConsumerWithSchemaOnExistingTopicWithoutSchema() {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer().topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            Assert.fail((String)"Shouldn't be able to consume with a schema from a topic which has no schema set");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException.IncompatibleSchemaException));
        }
    }

    @Test
    public void newConsumerWithSchemaTopicHasSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            V1Data toSend = new V1Data(1);
            p.send((Object)toSend);
            Assert.assertEquals((Object)toSend, (Object)c.receive().getValue());
        }
    }

    @Test
    public void newBytesConsumerWithTopicWithSchema() throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).create();
             Consumer c = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe();){
            p.send((Object)new V1Data(1));
            Assert.assertTrue((((byte[])c.receive().getValue()).length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void getSchemaVersionFromMessagesBatchingDisabled() throws Exception {
        this.getSchemaVersionFromMessages(false);
    }

    @Test
    public void getSchemaVersionFromMessagesBatchingEnabled() throws Exception {
        this.getSchemaVersionFromMessages(true);
    }

    private void getSchemaVersionFromMessages(boolean batching) throws Exception {
        String topic = "my-property/my-ns/schema-test";
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).enableBatching(batching).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AVRO(V1Data.class)).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            p.send((Object)new V1Data(1));
            Message data = c.receive();
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertEquals((Object)data.getValue(), (Object)new V1Data(1));
        }
    }

    @Test(dataProvider="batchingModes")
    public void testAutoConsume(boolean batching) throws Exception {
        String topic = "my-property/my-ns/schema-test-auto-consume-" + batching;
        try (Producer p = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic(topic).enableBatching(batching).create();
             Consumer c = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            int i;
            int numMessages = 10;
            for (i = 0; i < numMessages; ++i) {
                p.sendAsync((Object)new V1Data(i));
            }
            p.flush();
            for (i = 0; i < numMessages; ++i) {
                Message data = c.receive();
                Assert.assertNotNull((Object)data.getSchemaVersion());
                Assert.assertEquals((Object)((GenericRecord)data.getValue()).getField("i"), (Object)i);
                MessageImpl impl = (MessageImpl)data;
                org.apache.avro.Schema avroSchema = (org.apache.avro.Schema)impl.getSchemaInternal().getNativeSchema().get();
                Assert.assertNotNull((Object)avroSchema);
                org.apache.avro.Schema avroSchema2 = (org.apache.avro.Schema)((Schema)data.getReaderSchema().get()).getNativeSchema().get();
                Assert.assertNotNull((Object)avroSchema2);
            }
        }
    }

    @Test(dataProvider="batchingModesAndValueEncodingType")
    public void testAutoKeyValueConsume(boolean batching, KeyValueEncodingType keyValueEncodingType) throws Exception {
        Message data;
        KeyValue data2;
        Message wrapper;
        int i;
        int numMessages2;
        Throwable throwable;
        Consumer c42;
        Throwable throwable2;
        Consumer c32;
        Throwable throwable3;
        Consumer c22;
        Throwable throwable4;
        Consumer c12;
        Throwable throwable5;
        Consumer c02;
        Throwable throwable6;
        Producer p;
        String topic = "my-property/my-ns/schema-test-auto-keyvalue-consume-" + batching + "-" + keyValueEncodingType;
        Schema pojoSchema = Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)keyValueEncodingType);
        try (Consumer c3before = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub3b").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            List allSchemas = this.getPulsar().getAdminClient().schemas().getAllSchemas(topic);
            Assert.assertTrue((boolean)allSchemas.isEmpty());
            p = this.pulsarClient.newProducer(pojoSchema).topic(topic).enableBatching(batching).create();
            throwable6 = null;
            try {
                c02 = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub0").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                throwable5 = null;
                try {
                    c12 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub1").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                    throwable4 = null;
                    try {
                        c22 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub2").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                        throwable3 = null;
                        try {
                            c32 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub3").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                            throwable2 = null;
                            try {
                                c42 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub4").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
                                throwable = null;
                                try {
                                    KeyValueSchemaImpl keyValueSchema;
                                    numMessages2 = 10;
                                    for (i = 0; i < numMessages2; ++i) {
                                        p.sendAsync((Object)new KeyValue((Object)new V1Data(i * 100), (Object)new V1Data(i * 1000)));
                                    }
                                    p.flush();
                                    for (i = 0; i < numMessages2; ++i) {
                                        wrapper = c02.receive();
                                        data2 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
                                        Assert.assertNotNull((Object)wrapper.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)data2.getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)data2.getValue()).getField("i"), (Object)(i * 1000));
                                        c02.acknowledge(wrapper);
                                        Schema schema = (Schema)wrapper.getReaderSchema().get();
                                        KeyValueSchemaImpl keyValueSchema2 = (KeyValueSchemaImpl)schema;
                                        Assert.assertEquals((Object)SchemaType.AVRO, (Object)keyValueSchema2.getKeySchema().getSchemaInfo().getType());
                                        Assert.assertEquals((Object)SchemaType.AVRO, (Object)keyValueSchema2.getValueSchema().getSchemaInfo().getType());
                                        Assert.assertNotNull((Object)schema.getSchemaInfo());
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c12.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
                                        c12.acknowledge(data);
                                        keyValueSchema = (KeyValueSchemaImpl)data.getReaderSchema().get();
                                        Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                                        Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c22.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                                        Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        c22.acknowledge(data);
                                        keyValueSchema = (KeyValueSchemaImpl)data.getReaderSchema().get();
                                        Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                                        Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c32.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        c32.acknowledge(data);
                                        keyValueSchema = (KeyValueSchemaImpl)data.getReaderSchema().get();
                                        Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                                        Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c3before.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        c3before.acknowledge(data);
                                        keyValueSchema = (KeyValueSchemaImpl)data.getReaderSchema().get();
                                        Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                                        Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c42.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((int)((V1Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
                                        c42.acknowledge(data);
                                    }
                                }
                                catch (Throwable numMessages2) {
                                    throwable = numMessages2;
                                    throw numMessages2;
                                }
                                finally {
                                    if (c42 != null) {
                                        if (throwable != null) {
                                            try {
                                                c42.close();
                                            }
                                            catch (Throwable numMessages2) {
                                                throwable.addSuppressed(numMessages2);
                                            }
                                        } else {
                                            c42.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable c42) {
                                throwable2 = c42;
                                throw c42;
                            }
                            finally {
                                if (c32 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            c32.close();
                                        }
                                        catch (Throwable c42) {
                                            throwable2.addSuppressed(c42);
                                        }
                                    } else {
                                        c32.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable c32) {
                            throwable3 = c32;
                            throw c32;
                        }
                        finally {
                            if (c22 != null) {
                                if (throwable3 != null) {
                                    try {
                                        c22.close();
                                    }
                                    catch (Throwable c32) {
                                        throwable3.addSuppressed(c32);
                                    }
                                } else {
                                    c22.close();
                                }
                            }
                        }
                    }
                    catch (Throwable c22) {
                        throwable4 = c22;
                        throw c22;
                    }
                    finally {
                        if (c12 != null) {
                            if (throwable4 != null) {
                                try {
                                    c12.close();
                                }
                                catch (Throwable c22) {
                                    throwable4.addSuppressed(c22);
                                }
                            } else {
                                c12.close();
                            }
                        }
                    }
                }
                catch (Throwable c12) {
                    throwable5 = c12;
                    throw c12;
                }
                finally {
                    if (c02 != null) {
                        if (throwable5 != null) {
                            try {
                                c02.close();
                            }
                            catch (Throwable c12) {
                                throwable5.addSuppressed(c12);
                            }
                        } else {
                            c02.close();
                        }
                    }
                }
            }
            catch (Throwable c02) {
                throwable6 = c02;
                throw c02;
            }
            finally {
                if (p != null) {
                    if (throwable6 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable c02) {
                            throwable6.addSuppressed(c02);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        Schema pojoSchemaV2 = Schema.KeyValue((Schema)Schema.AVRO(V2Data.class), (Schema)Schema.AVRO(V2Data.class), (KeyValueEncodingType)keyValueEncodingType);
        try (Consumer c3before = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AVRO(V2Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub3b").subscribe();){
            p = this.pulsarClient.newProducer(pojoSchemaV2).topic(topic).enableBatching(batching).create();
            throwable6 = null;
            try {
                c02 = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub0").subscribe();
                throwable5 = null;
                try {
                    c12 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub1").subscribe();
                    throwable4 = null;
                    try {
                        c22 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V2Data.class), (Schema)Schema.AVRO(V2Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub2").subscribe();
                        throwable3 = null;
                        try {
                            c32 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AUTO_CONSUME(), (Schema)Schema.AVRO(V2Data.class), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub3").subscribe();
                            throwable2 = null;
                            try {
                                c42 = this.pulsarClient.newConsumer(Schema.KeyValue((Schema)Schema.AVRO(V2Data.class), (Schema)Schema.AUTO_CONSUME(), (KeyValueEncodingType)keyValueEncodingType)).topic(new String[]{topic}).subscriptionName("sub4").subscribe();
                                throwable = null;
                                try {
                                    numMessages2 = 10;
                                    for (i = 0; i < numMessages2; ++i) {
                                        p.sendAsync((Object)new KeyValue((Object)new V2Data(i * 100, i), (Object)new V2Data(i * 1000, i * 20)));
                                    }
                                    p.flush();
                                    for (i = 0; i < numMessages2; ++i) {
                                        wrapper = c02.receive();
                                        data2 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
                                        Assert.assertNotNull((Object)wrapper.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)data2.getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)data2.getValue()).getField("i"), (Object)(i * 1000));
                                        Assert.assertEquals((Object)((GenericRecord)data2.getKey()).getField("j"), (Object)i);
                                        Assert.assertEquals((Object)((GenericRecord)data2.getValue()).getField("j"), (Object)(i * 20));
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c12.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("j"), (Object)i);
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("j"), (Object)(i * 20));
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c22.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((int)((V2Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                                        Assert.assertEquals((int)((V2Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        Assert.assertEquals((Object)((V2Data)((KeyValue)data.getValue()).getKey()).j, (Object)i);
                                        Assert.assertEquals((Object)((V2Data)((KeyValue)data.getValue()).getValue()).j, (Object)(i * 20));
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c32.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((int)((V2Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("j"), (Object)i);
                                        Assert.assertEquals((Object)((V2Data)((KeyValue)data.getValue()).getValue()).j, (Object)(i * 20));
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c3before.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("i"), (Object)(i * 100));
                                        Assert.assertEquals((int)((V2Data)((KeyValue)data.getValue()).getValue()).i, (int)(i * 1000));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getKey()).getField("j"), (Object)i);
                                        Assert.assertEquals((Object)((V2Data)((KeyValue)data.getValue()).getValue()).j, (Object)(i * 20));
                                    }
                                    for (i = 0; i < numMessages2; ++i) {
                                        data = c42.receive();
                                        Assert.assertNotNull((Object)data.getSchemaVersion());
                                        Assert.assertEquals((int)((V2Data)((KeyValue)data.getValue()).getKey()).i, (int)(i * 100));
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("i"), (Object)(i * 1000));
                                        Assert.assertEquals((Object)((V2Data)((KeyValue)data.getValue()).getKey()).j, (Object)i);
                                        Assert.assertEquals((Object)((GenericRecord)((KeyValue)data.getValue()).getValue()).getField("j"), (Object)(i * 20));
                                    }
                                }
                                catch (Throwable throwable7) {
                                    throwable = throwable7;
                                    throw throwable7;
                                }
                                finally {
                                    if (c42 != null) {
                                        if (throwable != null) {
                                            try {
                                                c42.close();
                                            }
                                            catch (Throwable throwable8) {
                                                throwable.addSuppressed(throwable8);
                                            }
                                        } else {
                                            c42.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable9) {
                                throwable2 = throwable9;
                                throw throwable9;
                            }
                            finally {
                                if (c32 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            c32.close();
                                        }
                                        catch (Throwable throwable10) {
                                            throwable2.addSuppressed(throwable10);
                                        }
                                    } else {
                                        c32.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            throwable3 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (c22 != null) {
                                if (throwable3 != null) {
                                    try {
                                        c22.close();
                                    }
                                    catch (Throwable throwable12) {
                                        throwable3.addSuppressed(throwable12);
                                    }
                                } else {
                                    c22.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable13) {
                        throwable4 = throwable13;
                        throw throwable13;
                    }
                    finally {
                        if (c12 != null) {
                            if (throwable4 != null) {
                                try {
                                    c12.close();
                                }
                                catch (Throwable throwable14) {
                                    throwable4.addSuppressed(throwable14);
                                }
                            } else {
                                c12.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable15) {
                    throwable5 = throwable15;
                    throw throwable15;
                }
                finally {
                    if (c02 != null) {
                        if (throwable5 != null) {
                            try {
                                c02.close();
                            }
                            catch (Throwable throwable16) {
                                throwable5.addSuppressed(throwable16);
                            }
                        } else {
                            c02.close();
                        }
                    }
                }
            }
            catch (Throwable throwable17) {
                throwable6 = throwable17;
                throw throwable17;
            }
            finally {
                if (p != null) {
                    if (throwable6 != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable18) {
                            throwable6.addSuppressed(throwable18);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
    }

    @Test
    public void testAutoKeyValueConsumeGenericObject() throws Exception {
        String topic = "my-property/my-ns/schema-test-auto-keyvalue-consume-" + UUID.randomUUID();
        Schema pojoSchema = Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED);
        try (Producer p = this.pulsarClient.newProducer(pojoSchema).topic(topic).create();
             Consumer c0 = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub0").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            int i;
            int numMessages = 10;
            for (i = 0; i < numMessages; ++i) {
                p.sendAsync((Object)new KeyValue((Object)new V1Data(i * 100), (Object)new V1Data(i * 1000)));
            }
            p.flush();
            for (i = 0; i < numMessages; ++i) {
                Message wrapper = c0.receive();
                KeyValue data = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
                Assert.assertNotNull((Object)wrapper.getSchemaVersion());
                Assert.assertEquals((Object)((GenericRecord)data.getKey()).getField("i"), (Object)(i * 100));
                Assert.assertEquals((Object)((GenericRecord)data.getValue()).getField("i"), (Object)(i * 1000));
                c0.acknowledge(wrapper);
                KeyValueSchemaImpl keyValueSchema = (KeyValueSchemaImpl)wrapper.getReaderSchema().get();
                Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                Assert.assertTrue((boolean)keyValueSchema.getKeySchema().getSchemaInfo().getSchemaDefinition().contains("V1Data"));
                Assert.assertTrue((boolean)keyValueSchema.getValueSchema().getSchemaInfo().getSchemaDefinition().contains("V1Data"));
                Assert.assertTrue((boolean)keyValueSchema.getKeySchema().getNativeSchema().isPresent());
                Assert.assertTrue((boolean)keyValueSchema.getValueSchema().getNativeSchema().isPresent());
            }
            Schema pojoSchemaV2 = Schema.KeyValue((Schema)Schema.AVRO(V2Data.class), (Schema)Schema.AVRO(V2Data.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED);
            try (Producer p2 = this.pulsarClient.newProducer(pojoSchemaV2).topic(topic).create();){
                int i2;
                for (i2 = 0; i2 < numMessages; ++i2) {
                    p2.sendAsync((Object)new KeyValue((Object)new V2Data(i2 * 100, i2), (Object)new V2Data(i2 * 1000, i2 * 20)));
                }
                p2.flush();
                for (i2 = 0; i2 < numMessages; ++i2) {
                    Message wrapper = c0.receive();
                    KeyValue data = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
                    Assert.assertNotNull((Object)wrapper.getSchemaVersion());
                    Assert.assertEquals((Object)((GenericRecord)data.getKey()).getField("i"), (Object)(i2 * 100));
                    Assert.assertEquals((Object)((GenericRecord)data.getValue()).getField("i"), (Object)(i2 * 1000));
                    Assert.assertEquals((Object)((GenericRecord)data.getKey()).getField("j"), (Object)i2);
                    Assert.assertEquals((Object)((GenericRecord)data.getValue()).getField("j"), (Object)(i2 * 20));
                    KeyValueSchemaImpl keyValueSchema = (KeyValueSchemaImpl)wrapper.getReaderSchema().get();
                    Assert.assertNotNull((Object)keyValueSchema.getKeySchema());
                    Assert.assertNotNull((Object)keyValueSchema.getValueSchema());
                    Assert.assertTrue((boolean)keyValueSchema.getKeySchema().getSchemaInfo().getSchemaDefinition().contains("V2Data"));
                    Assert.assertTrue((boolean)keyValueSchema.getValueSchema().getSchemaInfo().getSchemaDefinition().contains("V2Data"));
                    Assert.assertTrue((boolean)keyValueSchema.getKeySchema().getNativeSchema().isPresent());
                    Assert.assertTrue((boolean)keyValueSchema.getValueSchema().getNativeSchema().isPresent());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSchemaByVersion() throws PulsarClientException, PulsarAdminException, ExecutionException, InterruptedException {
        String topic = "persistent://my-property/my-ns/testGetSchemaByVersion";
        PulsarClientImpl httpProtocolClient = (PulsarClientImpl)PulsarClient.builder().serviceUrl(this.brokerUrl.toString()).build();
        try {
            PulsarClientImpl binaryProtocolClient = (PulsarClientImpl)this.pulsarClient;
            this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic("persistent://my-property/my-ns/testGetSchemaByVersion").create();
            this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic("persistent://my-property/my-ns/testGetSchemaByVersion").create();
            LookupService httpLookupService = httpProtocolClient.getLookup();
            LookupService binaryLookupService = binaryProtocolClient.getLookup();
            Assert.assertTrue((boolean)(httpLookupService instanceof HttpLookupService));
            Assert.assertTrue((boolean)(binaryLookupService instanceof BinaryProtoLookupService));
            Assert.assertEquals((int)this.admin.schemas().getAllSchemas("persistent://my-property/my-ns/testGetSchemaByVersion").size(), (int)2);
            Assert.assertTrue((boolean)((Optional)httpLookupService.getSchema(TopicName.get((String)"persistent://my-property/my-ns/testGetSchemaByVersion"), ByteBuffer.allocate(8).putLong(0L).array()).get()).isPresent());
            Assert.assertTrue((boolean)((Optional)httpLookupService.getSchema(TopicName.get((String)"persistent://my-property/my-ns/testGetSchemaByVersion"), ByteBuffer.allocate(8).putLong(1L).array()).get()).isPresent());
            Assert.assertTrue((boolean)((Optional)binaryLookupService.getSchema(TopicName.get((String)"persistent://my-property/my-ns/testGetSchemaByVersion"), ByteBuffer.allocate(8).putLong(0L).array()).get()).isPresent());
            Assert.assertTrue((boolean)((Optional)binaryLookupService.getSchema(TopicName.get((String)"persistent://my-property/my-ns/testGetSchemaByVersion"), ByteBuffer.allocate(8).putLong(1L).array()).get()).isPresent());
        }
        finally {
            if (Collections.singletonList(httpProtocolClient).get(0) != null) {
                httpProtocolClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNativeSchemaWithAutoConsumeWithMultiVersion() throws Exception {
        String topic = "persistent://my-property/my-ns/testGetSchemaWithMultiVersion";
        Consumer consumer = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).subscriptionName("test").topic(new String[]{"persistent://my-property/my-ns/testGetSchemaWithMultiVersion"}).subscribe();
        try {
            Producer v1DataProducer = this.pulsarClient.newProducer(Schema.AVRO(V1Data.class)).topic("persistent://my-property/my-ns/testGetSchemaWithMultiVersion").create();
            try {
                Producer v2DataProducer = this.pulsarClient.newProducer(Schema.AVRO(V2Data.class)).topic("persistent://my-property/my-ns/testGetSchemaWithMultiVersion").create();
                try {
                    Assert.assertEquals((int)this.admin.schemas().getAllSchemas("persistent://my-property/my-ns/testGetSchemaWithMultiVersion").size(), (int)2);
                    v1DataProducer.send((Object)new V1Data());
                    v2DataProducer.send((Object)new V2Data());
                    Message messageV1 = consumer.receive();
                    Schema schemaV1 = (Schema)messageV1.getReaderSchema().get();
                    Message messageV2 = consumer.receive();
                    Schema schemaV2 = (Schema)messageV2.getReaderSchema().get();
                    log.info("schemaV1 {} {}", (Object)schemaV1.getSchemaInfo(), (Object)schemaV1.getNativeSchema());
                    log.info("schemaV2 {} {}", (Object)schemaV2.getSchemaInfo(), (Object)schemaV2.getNativeSchema());
                    Assert.assertTrue((boolean)schemaV1.getSchemaInfo().getSchemaDefinition().contains("V1Data"));
                    Assert.assertTrue((boolean)schemaV2.getSchemaInfo().getSchemaDefinition().contains("V2Data"));
                    org.apache.avro.Schema avroSchemaV1 = (org.apache.avro.Schema)schemaV1.getNativeSchema().get();
                    org.apache.avro.Schema avroSchemaV2 = (org.apache.avro.Schema)schemaV2.getNativeSchema().get();
                    Assert.assertNotEquals((Object)avroSchemaV1.toString(false), (Object)avroSchemaV2.toString(false));
                    Assert.assertTrue((boolean)avroSchemaV1.toString(false).contains("V1Data"));
                    Assert.assertTrue((boolean)avroSchemaV2.toString(false).contains("V2Data"));
                }
                finally {
                    if (Collections.singletonList(v2DataProducer).get(0) != null) {
                        v2DataProducer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(v1DataProducer).get(0) != null) {
                    v1DataProducer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @Test(dataProvider="topicDomain")
    public void testAutoCreatedSchema(String domain) throws Exception {
        String topic1 = domain + "my-property/my-ns/testAutoCreatedSchema-1";
        String topic2 = domain + "my-property/my-ns/testAutoCreatedSchema-2";
        this.pulsarClient.newProducer(Schema.BYTES).topic(topic1).create().close();
        try {
            this.admin.schemas().getSchemaInfo(topic1);
            Assert.fail((String)"The schema of topic1 should not exist");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)404);
        }
        this.pulsarClient.newProducer(Schema.STRING).topic(topic1).create().close();
        Assert.assertEquals((Object)this.admin.schemas().getSchemaInfo(topic1).getType(), (Object)SchemaType.STRING);
        this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{topic2}).subscriptionName("sub").subscribe().close();
        try {
            this.admin.schemas().getSchemaInfo(topic2);
            Assert.fail((String)"The schema of topic2 should not exist");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)404);
        }
        this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic2}).subscriptionName("sub").subscribe().close();
        Assert.assertEquals((Object)this.admin.schemas().getSchemaInfo(topic2).getType(), (Object)SchemaType.STRING);
    }

    @DataProvider(name="keyEncodingType")
    public static Object[] keyEncodingType() {
        return new Object[]{KeyValueEncodingType.SEPARATED, KeyValueEncodingType.INLINE};
    }

    @Test(dataProvider="keyEncodingType")
    public void testAutoKeyValueConsumeGenericObjectNullValues(KeyValueEncodingType encodingType) throws Exception {
        String topic = "my-property/my-ns/schema-test-auto-keyvalue-" + encodingType + "-null-value-consume-" + UUID.randomUUID();
        Schema pojoSchema = Schema.KeyValue((Schema)Schema.AVRO(V1Data.class), (Schema)Schema.AVRO(V1Data.class), (KeyValueEncodingType)encodingType);
        try (Producer p = this.pulsarClient.newProducer(pojoSchema).topic(topic).create();
             Consumer c0 = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{topic}).subscriptionName("sub0").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
            p.send((Object)new KeyValue((Object)new V1Data(1), (Object)new V1Data(2)));
            p.send((Object)new KeyValue((Object)new V1Data(1), null));
            p.send((Object)new KeyValue(null, (Object)new V1Data(2)));
            p.send((Object)new KeyValue(null, null));
            Message wrapper = c0.receive();
            Assert.assertEquals((Object)encodingType, (Object)((KeyValueSchemaImpl)wrapper.getReaderSchema().get()).getKeyValueEncodingType());
            KeyValue data1 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
            Assert.assertEquals((Object)1, (Object)((GenericRecord)data1.getKey()).getField("i"));
            Assert.assertEquals((Object)2, (Object)((GenericRecord)data1.getValue()).getField("i"));
            wrapper = c0.receive();
            KeyValue data2 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
            Assert.assertEquals((Object)1, (Object)((GenericRecord)data2.getKey()).getField("i"));
            Assert.assertNull((Object)data2.getValue());
            wrapper = c0.receive();
            KeyValue data3 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
            Assert.assertNull((Object)data3.getKey());
            Assert.assertEquals((Object)2, (Object)((GenericRecord)data3.getValue()).getField("i"));
            wrapper = c0.receive();
            KeyValue data4 = (KeyValue)((GenericRecord)wrapper.getValue()).getNativeObject();
            Assert.assertNull((Object)data4.getKey());
            Assert.assertNull((Object)data4.getValue());
        }
    }

    @Test
    public void testConsumeAvroMessagesWithoutSchema() throws Exception {
        int i;
        if (this.schemaValidationEnforced) {
            return;
        }
        String topic = "test-consume-avro-messages-without-schema-" + UUID.randomUUID();
        Schema schema = Schema.AVRO(V1Data.class);
        Consumer consumer = this.pulsarClient.newConsumer(schema).topic(new String[]{topic}).subscriptionName("sub").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        int numMessages = 5;
        for (i = 0; i < 5; ++i) {
            producer.send((Object)schema.encode((Object)new V1Data(i)));
        }
        for (i = 0; i < 5; ++i) {
            Message msg = consumer.receive(3, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)msg);
            log.info("Received {} from {}", (Object)((V1Data)msg.getValue()).i, (Object)topic);
            Assert.assertEquals((int)((V1Data)msg.getValue()).i, (int)i);
            Assert.assertEquals((Object)msg.getReaderSchema().orElse(Schema.BYTES).getSchemaInfo(), (Object)schema.getSchemaInfo());
            consumer.acknowledge(msg);
        }
        producer.close();
        consumer.close();
    }

    static class IncompatibleData {
        int i;
        int j;

        public static IncompatibleDataBuilder builder() {
            return new IncompatibleDataBuilder();
        }

        public int getI() {
            return this.i;
        }

        public int getJ() {
            return this.j;
        }

        public void setI(int i) {
            this.i = i;
        }

        public void setJ(int j) {
            this.j = j;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IncompatibleData)) {
                return false;
            }
            IncompatibleData other = (IncompatibleData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getI() != other.getI()) {
                return false;
            }
            return this.getJ() == other.getJ();
        }

        protected boolean canEqual(Object other) {
            return other instanceof IncompatibleData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getI();
            result = result * 59 + this.getJ();
            return result;
        }

        public String toString() {
            return "SimpleSchemaTest.IncompatibleData(i=" + this.getI() + ", j=" + this.getJ() + ")";
        }

        public IncompatibleData() {
        }

        public IncompatibleData(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public static class IncompatibleDataBuilder {
            private int i;
            private int j;

            IncompatibleDataBuilder() {
            }

            public IncompatibleDataBuilder i(int i) {
                this.i = i;
                return this;
            }

            public IncompatibleDataBuilder j(int j) {
                this.j = j;
                return this;
            }

            public IncompatibleData build() {
                return new IncompatibleData(this.i, this.j);
            }

            public String toString() {
                return "SimpleSchemaTest.IncompatibleData.IncompatibleDataBuilder(i=" + this.i + ", j=" + this.j + ")";
            }
        }
    }

    static class V2Data {
        int i;
        Integer j;

        public static V2DataBuilder builder() {
            return new V2DataBuilder();
        }

        public int getI() {
            return this.i;
        }

        public Integer getJ() {
            return this.j;
        }

        public void setI(int i) {
            this.i = i;
        }

        public void setJ(Integer j) {
            this.j = j;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof V2Data)) {
                return false;
            }
            V2Data other = (V2Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getI() != other.getI()) {
                return false;
            }
            Integer this$j = this.getJ();
            Integer other$j = other.getJ();
            return !(this$j == null ? other$j != null : !((Object)this$j).equals(other$j));
        }

        protected boolean canEqual(Object other) {
            return other instanceof V2Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getI();
            Integer $j = this.getJ();
            result = result * 59 + ($j == null ? 43 : ((Object)$j).hashCode());
            return result;
        }

        public String toString() {
            return "SimpleSchemaTest.V2Data(i=" + this.getI() + ", j=" + this.getJ() + ")";
        }

        public V2Data() {
        }

        public V2Data(int i, Integer j) {
            this.i = i;
            this.j = j;
        }

        public static class V2DataBuilder {
            private int i;
            private Integer j;

            V2DataBuilder() {
            }

            public V2DataBuilder i(int i) {
                this.i = i;
                return this;
            }

            public V2DataBuilder j(Integer j) {
                this.j = j;
                return this;
            }

            public V2Data build() {
                return new V2Data(this.i, this.j);
            }

            public String toString() {
                return "SimpleSchemaTest.V2Data.V2DataBuilder(i=" + this.i + ", j=" + this.j + ")";
            }
        }
    }

    static class V1Data {
        int i;

        public static V1DataBuilder builder() {
            return new V1DataBuilder();
        }

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof V1Data)) {
                return false;
            }
            V1Data other = (V1Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getI() == other.getI();
        }

        protected boolean canEqual(Object other) {
            return other instanceof V1Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getI();
            return result;
        }

        public String toString() {
            return "SimpleSchemaTest.V1Data(i=" + this.getI() + ")";
        }

        public V1Data() {
        }

        public V1Data(int i) {
            this.i = i;
        }

        public static class V1DataBuilder {
            private int i;

            V1DataBuilder() {
            }

            public V1DataBuilder i(int i) {
                this.i = i;
                return this;
            }

            public V1Data build() {
                return new V1Data(this.i);
            }

            public String toString() {
                return "SimpleSchemaTest.V1Data.V1DataBuilder(i=" + this.i + ")";
            }
        }
    }
}

