/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class TenantTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testMaxTenant() throws Exception {
        this.conf.setMaxTenants(2);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("testTenant1", (TenantInfo)tenantInfo);
        this.admin.tenants().createTenant("testTenant2", (TenantInfo)tenantInfo);
        try {
            this.admin.tenants().createTenant("testTenant3", (TenantInfo)tenantInfo);
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
            Assert.assertEquals((String)e.getHttpError(), (String)"Exceed the maximum number of tenants");
        }
        super.internalCleanup();
        this.conf.setMaxTenants(0);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        for (int i = 0; i < 10; ++i) {
            this.admin.tenants().createTenant("testTenant-unlimited" + i, (TenantInfo)tenantInfo);
        }
    }
}

