/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class CompactedOutBatchMessageTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testCompactedOutMessages() throws Exception {
        String topic1 = "persistent://my-property/my-ns/my-topic";
        BrokerEntryMetadata brokerEntryMetadata = new BrokerEntryMetadata().setBrokerTimestamp(1L).setBrokerTimestamp(1L);
        MessageMetadata metadata = new MessageMetadata().setProducerName("foobar").setSequenceId(1L).setPublishTime(1L).setNumMessagesInBatch(3);
        ByteBuf batchBuffer = Unpooled.buffer((int)1000);
        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)new SingleMessageMetadata().setCompactedOut(true).setPartitionKey("key1"), (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)new SingleMessageMetadata().setCompactedOut(true).setPartitionKey("key2"), (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)new SingleMessageMetadata().setCompactedOut(false).setPartitionKey("key3"), (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
        Commands.serializeSingleMessageInBatchWithPayload((SingleMessageMetadata)new SingleMessageMetadata().setCompactedOut(true).setPartitionKey("key4"), (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
        try (ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic"}).subscriptionName("my-subscriber-name").subscribe();){
            consumer.receiveIndividualMessagesFromBatch(brokerEntryMetadata, metadata, 0, null, batchBuffer, new MessageIdData().setLedgerId(1234L).setEntryId(567L), consumer.cnx());
            Message m = consumer.receive();
            Assert.assertEquals((long)((BatchMessageIdImpl)m.getMessageId()).getLedgerId(), (long)1234L);
            Assert.assertEquals((long)((BatchMessageIdImpl)m.getMessageId()).getEntryId(), (long)567L);
            Assert.assertEquals((int)((BatchMessageIdImpl)m.getMessageId()).getBatchIndex(), (int)2);
            Assert.assertEquals((String)m.getKey(), (String)"key3");
            Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
        }
    }
}

