/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ConsumerAckResponseTest
extends ProducerConsumerBase {
    private static final TransactionImpl transaction = (TransactionImpl)Mockito.mock(TransactionImpl.class);

    @Override
    @BeforeClass
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        ((TransactionImpl)Mockito.doReturn((Object)1L).when((Object)transaction)).getTxnIdLeastBits();
        ((TransactionImpl)Mockito.doReturn((Object)1L).when((Object)transaction)).getTxnIdMostBits();
        ((TransactionImpl)Mockito.doReturn((Object)TransactionImpl.State.OPEN).when((Object)transaction)).getState();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        ((TransactionImpl)Mockito.doNothing().when((Object)transaction)).registerAckOp((CompletableFuture)ArgumentMatchers.any());
        ((TransactionImpl)Mockito.doReturn((Object)true).when((Object)transaction)).checkIfOpen((CompletableFuture)ArgumentMatchers.any());
        ((TransactionImpl)Mockito.doReturn(completableFuture).when((Object)transaction)).registerAckedTopic((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Thread.sleep(3000L);
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAckResponse() throws PulsarClientException, InterruptedException {
        String topic = "testAckResponse";
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).enableBatching(false).create();
        try {
            ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("sub").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscribe();
            try {
                producer.send((Object)1);
                producer.send((Object)2);
                try {
                    consumer.acknowledgeAsync((MessageId)new MessageIdImpl(1L, 1L, 1), (Transaction)transaction).get();
                    Assert.fail();
                }
                catch (ExecutionException e) {
                    Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.NotAllowedException));
                }
                Message message = consumer.receive();
                try {
                    consumer.acknowledgeAsync(message.getMessageId(), (Transaction)transaction).get();
                    Assert.fail();
                }
                catch (ExecutionException e) {
                    Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.NotAllowedException));
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

