/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.Schema;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ConsumerDedupPermitsUpdateTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="combinations")
    public Object[][] combinations() {
        return new Object[][]{{false, 0}, {false, 1}, {false, 10}, {false, 100}, {true, 1}, {true, 10}, {true, 100}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L, dataProvider="combinations")
    public void testConsumerDedup(boolean batchingEnabled, int receiverQueueSize) throws Exception {
        String topic = BrokerTestUtil.newUniqueName("persistent://my-property/my-ns/my-topic");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("test").acknowledgmentGroupTime(1L, TimeUnit.HOURS).receiverQueueSize(receiverQueueSize).subscribe();
        try {
            int i;
            Message msg;
            int i2;
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).enableBatching(batchingEnabled).batchingMaxMessages(10).batchingMaxPublishDelay(1L, TimeUnit.HOURS).create();
            for (i2 = 0; i2 < 30; ++i2) {
                producer.sendAsync((Object)("hello-" + i2));
            }
            producer.flush();
            for (i2 = 0; i2 < 30; ++i2) {
                msg = consumer.receive();
                Assert.assertEquals((String)((String)msg.getValue()), (String)("hello-" + i2));
                consumer.acknowledge(msg);
            }
            this.admin.topics().unload(topic);
            if (receiverQueueSize > 0) {
                Message msg2 = consumer.receive(100, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)msg2);
            }
            for (i = 0; i < 30; ++i) {
                producer.sendAsync((Object)("new-message-" + i));
            }
            producer.flush();
            for (i = 0; i < 30; ++i) {
                msg = consumer.receive();
                Assert.assertEquals((String)((String)msg.getValue()), (String)("new-message-" + i));
                consumer.acknowledge(msg);
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

