/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ClientBuilderImpl;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PulsarClientConfigurationOverrideTest {
    @Test
    public void testFilterAndMapProperties() {
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.getProperties().setProperty("keepAliveIntervalSeconds", "15");
        conf.getProperties().setProperty("brokerClient_keepAliveIntervalSeconds", "25");
        Map result = PropertiesUtils.filterAndMapProperties((Properties)conf.getProperties(), (String)"brokerClient_");
        Assert.assertEquals((int)result.size(), (int)1, (String)"The filtered map should have one entry.");
        Assert.assertNull(result.get("brokerClient_keepAliveIntervalSeconds"), (String)"The mapped prop should not be in the result.");
        Assert.assertEquals(result.get("keepAliveIntervalSeconds"), (Object)"25", (String)"The original value is overridden.");
        ClientBuilder builder = PulsarClient.builder();
        Assert.assertEquals((int)((ClientBuilderImpl)builder).getClientConfigurationData().getKeepAliveIntervalSeconds(), (int)30);
        builder.loadConf(result);
        Assert.assertEquals((int)((ClientBuilderImpl)builder).getClientConfigurationData().getKeepAliveIntervalSeconds(), (int)25);
    }
}

