/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class RawMessageSerDeserTest {
    static final Logger log = LoggerFactory.getLogger(RawMessageSerDeserTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationAndDeserialization() {
        int payload = -1091581186;
        ByteBuf headersAndPayload = Unpooled.buffer((int)4);
        headersAndPayload.writeInt(payload);
        MessageIdData id = new MessageIdData().setLedgerId(3840L).setEntryId(2986L).setPartition(10).setBatchIndex(20);
        RawMessageImpl m = new RawMessageImpl(id, headersAndPayload);
        try {
            ByteBuf serialized = m.serialize();
            byte[] bytes = new byte[serialized.readableBytes()];
            serialized.readBytes(bytes);
            RawMessage m2 = RawMessageImpl.deserializeFrom((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes));
            Assert.assertEquals((long)m2.getMessageIdData().getLedgerId(), (long)m.getMessageIdData().getLedgerId());
            Assert.assertEquals((long)m2.getMessageIdData().getEntryId(), (long)m.getMessageIdData().getEntryId());
            Assert.assertEquals((int)m2.getMessageIdData().getPartition(), (int)m.getMessageIdData().getPartition());
            Assert.assertEquals((int)m2.getMessageIdData().getBatchIndex(), (int)m.getMessageIdData().getBatchIndex());
            Assert.assertEquals((Object)m2.getHeadersAndPayload(), (Object)m.getHeadersAndPayload());
        }
        finally {
            if (Collections.singletonList(m).get(0) != null) {
                m.close();
            }
        }
    }
}

