/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.util.RetryUtil;
import org.apache.pulsar.common.util.FutureUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"utils"})
public class RetryUtilTest {
    @Test
    public void testFailAndRetry() throws Exception {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture callback = new CompletableFuture();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        Backoff backoff = new BackoffBuilder().setInitialTime(100L, TimeUnit.MILLISECONDS).setMax(2000L, TimeUnit.MILLISECONDS).setMandatoryStop(5000L, TimeUnit.MILLISECONDS).create();
        RetryUtil.retryAsynchronously(() -> {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            atomicInteger.incrementAndGet();
            if (atomicInteger.get() < 5) {
                future.completeExceptionally(new RuntimeException("fail"));
            } else {
                future.complete(true);
            }
            return future;
        }, (Backoff)backoff, (ScheduledExecutorService)executor, callback);
        Assert.assertTrue((boolean)((Boolean)callback.get()));
        Assert.assertEquals((int)atomicInteger.get(), (int)5);
        executor.shutdownNow();
    }

    @Test
    public void testFail() throws Exception {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture callback = new CompletableFuture();
        Backoff backoff = new BackoffBuilder().setInitialTime(500L, TimeUnit.MILLISECONDS).setMax(2000L, TimeUnit.MILLISECONDS).setMandatoryStop(5000L, TimeUnit.MILLISECONDS).create();
        long start = System.currentTimeMillis();
        RetryUtil.retryAsynchronously(() -> FutureUtil.failedFuture((Throwable)new RuntimeException("fail")), (Backoff)backoff, (ScheduledExecutorService)executor, callback);
        try {
            callback.get();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("fail"));
        }
        long time = System.currentTimeMillis() - start;
        Assert.assertTrue((time >= 3000L ? 1 : 0) != 0, (String)("Duration:" + time));
        executor.shutdownNow();
    }
}

