/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.processor;

import io.netty.buffer.ByteBuf;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;

public class CustomBatchFormat {
    public static final String KEY = "entry.format";
    public static final String VALUE = "custom";

    public static ByteBuf serialize(Iterable<String> strings) {
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(1024);
        buf.writeShort(0);
        int numMessages = 0;
        for (String s : strings) {
            CustomBatchFormat.writeString(buf, s);
            numMessages = (short)(numMessages + 1);
        }
        buf.setShort(0, numMessages);
        return buf;
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] bytes = Schema.STRING.encode((Object)s);
        buf.writeShort(bytes.length);
        buf.writeBytes(bytes);
    }

    public static Metadata readMetadata(ByteBuf buf) {
        return new Metadata(buf.readShort());
    }

    public static byte[] readMessage(ByteBuf buf) {
        short length = buf.readShort();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return bytes;
    }

    public static class Metadata {
        private final int numMessages;

        public Metadata(int numMessages) {
            this.numMessages = numMessages;
        }

        public int getNumMessages() {
            return this.numMessages;
        }
    }
}

