/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.processor;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessagePayload;
import org.apache.pulsar.client.api.MessagePayloadContext;
import org.apache.pulsar.client.api.MessagePayloadFactory;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.MessagePayloadUtils;
import org.apache.pulsar.client.processor.CustomBatchFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomBatchPayloadProcessor
implements MessagePayloadProcessor {
    private static final Logger log = LoggerFactory.getLogger(CustomBatchPayloadProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void process(MessagePayload payload, MessagePayloadContext context, Schema<T> schema, Consumer<Message<T>> messageConsumer) throws Exception {
        String value = context.getProperty("entry.format");
        if (value == null || !value.equals("custom")) {
            DEFAULT.process(payload, context, schema, messageConsumer);
            return;
        }
        ByteBuf buf = MessagePayloadUtils.convertToByteBuf((MessagePayload)payload);
        try {
            int numMessages = CustomBatchFormat.readMetadata(buf).getNumMessages();
            for (int i = 0; i < numMessages; ++i) {
                MessagePayload singlePayload = MessagePayloadFactory.DEFAULT.wrap(CustomBatchFormat.readMessage(buf));
                try {
                    messageConsumer.accept(context.getMessageAt(i, numMessages, singlePayload, false, schema));
                    continue;
                }
                finally {
                    singlePayload.release();
                }
            }
        }
        finally {
            buf.release();
        }
    }
}

