/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.processor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.processor.CustomBatchFormat;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomBatchProducer {
    private static final Logger log = LoggerFactory.getLogger(CustomBatchProducer.class);
    private final List<String> messages = new ArrayList<String>();
    private final PersistentTopic persistentTopic;
    private final int batchingMaxMessages;

    public void sendAsync(String value) {
        this.messages.add(value);
        if (this.messages.size() >= this.batchingMaxMessages) {
            this.flush();
        }
    }

    public void flush() {
        ByteBuf buf = CustomBatchFormat.serialize(this.messages);
        ByteBuf headerAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.None, (MessageMetadata)CustomBatchProducer.createCustomMetadata(), (ByteBuf)buf);
        buf.release();
        this.persistentTopic.publishMessage(headerAndPayload, (e, ledgerId, entryId) -> {
            if (e == null) {
                log.info("Send successfully to {} ({}, {})", new Object[]{this.persistentTopic.getName(), ledgerId, entryId});
            } else {
                log.error("Failed to send: {}", (Object)e.getMessage());
            }
        });
        this.messages.clear();
    }

    private static MessageMetadata createCustomMetadata() {
        MessageMetadata messageMetadata = new MessageMetadata();
        messageMetadata.setProducerName("");
        messageMetadata.setSequenceId(0L);
        messageMetadata.setPublishTime(0L);
        messageMetadata.addProperty().setKey("entry.format").setValue("custom");
        return messageMetadata;
    }

    public CustomBatchProducer(PersistentTopic persistentTopic, int batchingMaxMessages) {
        this.persistentTopic = persistentTopic;
        this.batchingMaxMessages = batchingMaxMessages;
    }
}

