/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FunctionStatsImpl;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactoryConfig;
import org.apache.pulsar.functions.worker.PulsarFunctionLocalRunTest;
import org.apache.pulsar.functions.worker.PulsarFunctionTestTemporaryDirectory;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.scheduler.RoundRobinScheduler;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functions-worker"})
public class PulsarFunctionPublishTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionPublishTest.class);
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    WorkerConfig workerConfig;
    URL urlTls;
    PulsarService pulsar;
    PulsarAdmin admin;
    PulsarClient pulsarClient;
    BrokerStats brokerStatsClient;
    PulsarWorkerService functionsWorkerService;
    final String tenant = "external-repl-prop";
    String pulsarFunctionsNamespace = "external-repl-prop/pulsar-function-admin";
    String primaryHost;
    String workerId;
    private final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/broker-cert.pem";
    private final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/broker-key.pem";
    private final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/authentication/tls/client-cert.pem";
    private final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/authentication/tls/client-key.pem";
    private final String TLS_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/cacert.pem";
    private PulsarFunctionTestTemporaryDirectory tempDirectory;

    @DataProvider(name="validRoleName")
    public Object[][] validRoleName() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @BeforeMethod
    void setup(Method method) throws Exception {
        log.info("--- Setting up method {} ---", (Object)method.getName());
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        this.config = (ServiceConfiguration)Mockito.spy(ServiceConfiguration.class);
        this.config.setClusterName("use");
        HashSet superUsers = Sets.newHashSet((Object[])new String[]{"superUser", "admin"});
        this.config.setSuperUserRoles((Set)superUsers);
        this.config.setWebServicePort(Optional.of(0));
        this.config.setWebServicePortTls(Optional.of(0));
        this.config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        this.config.setBrokerShutdownTimeoutMs(0L);
        this.config.setBrokerServicePort(Optional.of(0));
        this.config.setBrokerServicePortTls(Optional.of(0));
        this.config.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        this.config.setTlsAllowInsecureConnection(true);
        this.config.setAdvertisedAddress("localhost");
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        this.config.setAuthenticationEnabled(true);
        this.config.setAuthenticationProviders(providers);
        this.config.setAuthorizationEnabled(true);
        this.config.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.config.setTlsCertificateFilePath("./src/test/resources/authentication/tls/broker-cert.pem");
        this.config.setTlsKeyFilePath("./src/test/resources/authentication/tls/broker-key.pem");
        this.config.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.config.setBrokerClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.config.setBrokerClientAuthenticationParameters("tlsCertFile:./src/test/resources/authentication/tls/client-cert.pem,tlsKeyFile:./src/test/resources/authentication/tls/client-key.pem");
        this.config.setBrokerClientTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.config.setBrokerClientTlsEnabled(true);
        this.config.setAllowAutoTopicCreationType("non-partitioned");
        this.functionsWorkerService = this.createPulsarFunctionWorker(this.config);
        Optional<PulsarWorkerService> functionWorkerService = Optional.of(this.functionsWorkerService);
        this.pulsar = new PulsarService(this.config, this.workerConfig, functionWorkerService, exitCode -> {});
        this.pulsar.start();
        String brokerServiceUrl = this.pulsar.getWebServiceAddressTls();
        this.urlTls = new URL(brokerServiceUrl);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        AuthenticationTls authTls = new AuthenticationTls();
        authTls.configure(authParams);
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(brokerServiceUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(true).authentication((Authentication)authTls).build());
        this.brokerStatsClient = this.admin.brokerStats();
        this.primaryHost = this.pulsar.getWebServiceAddress();
        ClusterData clusterData = ClusterData.builder().serviceUrl(this.urlTls.toString()).build();
        this.admin.clusters().updateCluster(this.config.getClusterName(), clusterData);
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.workerConfig.getPulsarServiceUrl());
        if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getBrokerClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.workerConfig.getBrokerClientAuthenticationParameters())) {
            clientBuilder.enableTls(this.workerConfig.isUseTls());
            clientBuilder.allowTlsInsecureConnection(this.workerConfig.isTlsAllowInsecureConnection());
            clientBuilder.authentication(this.workerConfig.getBrokerClientAuthenticationPlugin(), this.workerConfig.getBrokerClientAuthenticationParameters());
        }
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        this.pulsarClient = clientBuilder.build();
        TenantInfo propAdmin = TenantInfo.builder().adminRoles(Collections.singleton("superUser")).allowedClusters(Collections.singleton("use")).build();
        this.admin.tenants().updateTenant("external-repl-prop", propAdmin);
        System.setProperty("pulsar.functions.java.instance.jar", FutureUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        while (!this.functionsWorkerService.getLeaderService().isLeader()) {
            Thread.sleep(1000L);
        }
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() throws Exception {
        try {
            log.info("--- Shutting down ---");
            this.pulsarClient.close();
            this.admin.close();
            this.functionsWorkerService.stop();
            this.pulsar.close();
            this.bkEnsemble.stop();
        }
        finally {
            if (this.tempDirectory != null) {
                this.tempDirectory.delete();
            }
        }
    }

    private PulsarWorkerService createPulsarFunctionWorker(ServiceConfiguration config) {
        this.workerConfig = new WorkerConfig();
        this.tempDirectory = PulsarFunctionTestTemporaryDirectory.create(this.getClass().getSimpleName());
        this.tempDirectory.useTemporaryDirectoriesForWorkerConfig(this.workerConfig);
        this.workerConfig.setPulsarFunctionsNamespace(this.pulsarFunctionsNamespace);
        this.workerConfig.setSchedulerClassName(RoundRobinScheduler.class.getName());
        this.workerConfig.setFunctionRuntimeFactoryClassName(ThreadRuntimeFactory.class.getName());
        this.workerConfig.setFunctionRuntimeFactoryConfigs((Map)ObjectMapperFactory.getThreadLocal().convertValue((Object)new ThreadRuntimeFactoryConfig().setThreadGroupName("use"), Map.class));
        this.workerConfig.setPulsarServiceUrl("pulsar://127.0.0.1:" + config.getBrokerServicePortTls().get());
        this.workerConfig.setPulsarWebServiceUrl("https://127.0.0.1:" + config.getWebServicePortTls().get());
        this.workerConfig.setFailureCheckFreqMs(100L);
        this.workerConfig.setNumFunctionPackageReplicas(1);
        this.workerConfig.setClusterCoordinationTopicName("coordinate");
        this.workerConfig.setFunctionAssignmentTopicName("assignment");
        this.workerConfig.setFunctionMetadataTopicName("metadata");
        this.workerConfig.setInstanceLivenessCheckFreqMs(100L);
        this.workerConfig.setWorkerPort(Integer.valueOf(0));
        this.workerConfig.setPulsarFunctionsCluster(config.getClusterName());
        String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getAdvertisedAddress());
        this.workerId = "c-" + config.getClusterName() + "-fw-" + hostname + "-" + this.workerConfig.getWorkerPort();
        this.workerConfig.setWorkerHostname(hostname);
        this.workerConfig.setWorkerId(this.workerId);
        this.workerConfig.setBrokerClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.workerConfig.setBrokerClientAuthenticationParameters(String.format("tlsCertFile:%s,tlsKeyFile:%s", "./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem"));
        this.workerConfig.setUseTls(true);
        this.workerConfig.setTlsAllowInsecureConnection(true);
        this.workerConfig.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.workerConfig.setAuthenticationEnabled(true);
        this.workerConfig.setAuthorizationEnabled(true);
        PulsarWorkerService workerService = new PulsarWorkerService();
        workerService.init(this.workerConfig, null, false);
        return workerService;
    }

    protected static FunctionConfig createFunctionConfig(String tenant, String namespace, String functionName, String sourceTopic, String publishTopic, String subscriptionName) {
        FunctionConfig functionConfig = new FunctionConfig();
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(functionName);
        functionConfig.setParallelism(Integer.valueOf(1));
        functionConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE);
        functionConfig.setSubName(subscriptionName);
        functionConfig.setInputs(Collections.singleton(sourceTopic));
        functionConfig.setAutoAck(Boolean.valueOf(true));
        functionConfig.setClassName("org.apache.pulsar.functions.api.examples.TypedMessageBuilderPublish");
        functionConfig.setRuntime(FunctionConfig.Runtime.JAVA);
        HashMap<String, String> userConfig = new HashMap<String, String>();
        userConfig.put("publish-topic", publishTopic);
        functionConfig.setUserConfig(userConfig);
        functionConfig.setCleanupSubscription(Boolean.valueOf(true));
        return functionConfig;
    }

    @Test(timeOut=20000L)
    public void testPulsarFunctionState() throws Exception {
        int i;
        String namespacePortion = "io";
        String replNamespace = "external-repl-prop/io";
        String sourceTopic = "persistent://external-repl-prop/io/input";
        String publishTopic = "persistent://external-repl-prop/io/publishtopic";
        String propertyKey = "key";
        String propertyValue = "value";
        String functionName = "PulsarFunction-test";
        String subscriptionName = "test-sub";
        this.admin.namespaces().createNamespace("external-repl-prop/io");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"}));
        this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/io/input").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://external-repl-prop/io/publishtopic"}).subscriptionName("sub").subscribe();
        FunctionConfig functionConfig = PulsarFunctionPublishTest.createFunctionConfig("external-repl-prop", "io", "PulsarFunction-test", "persistent://external-repl-prop/io/input", "persistent://external-repl-prop/io/publishtopic", "test-sub");
        String jarFilePathUrl = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar().toURI().toString();
        this.admin.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 1;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        Assert.assertEquals((int)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size(), (int)1);
        int totalMsgs = 5;
        for (i = 0; i < totalMsgs; ++i) {
            String data = "foo";
            producer.newMessage().property("key", "value").key(String.valueOf(i)).value((Object)data).send();
        }
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                SubscriptionStats subStats = (SubscriptionStats)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().get("test-sub");
                return subStats.getUnackedMessages() == 0L;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                FunctionStatsImpl functionStat = (FunctionStatsImpl)this.admin.functions().getFunctionStats("external-repl-prop", "io", "PulsarFunction-test");
                return functionStat.getProcessedSuccessfullyTotal() == 5L;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        for (i = 0; i < 5; ++i) {
            Message msg = consumer.receive(5, TimeUnit.SECONDS);
            String receivedPropertyValue = msg.getProperty("key");
            Assert.assertEquals((String)"value", (String)receivedPropertyValue);
            Assert.assertEquals((String)msg.getProperty("input_topic"), (String)"persistent://external-repl-prop/io/input");
            Assert.assertEquals((String)msg.getKey(), (String)String.valueOf(i));
        }
        Assert.assertNotEquals((Object)((SubscriptionStats)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().values().iterator().next()).getUnackedMessages(), (Object)totalMsgs);
        this.admin.functions().deleteFunction("external-repl-prop", "io", "PulsarFunction-test");
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 0;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        Assert.assertEquals((int)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size(), (int)0);
        this.tempDirectory.assertThatFunctionDownloadTempFilesHaveBeenDeleted();
    }

    @Test
    public void testMultipleAddress() throws Exception {
        String namespacePortion = "io";
        String replNamespace = "external-repl-prop/io";
        String sourceTopic = "persistent://external-repl-prop/io/input";
        String publishTopic = "persistent://external-repl-prop/io/publishtopic";
        String functionName = "PulsarFunction-test";
        String subscriptionName = "test-sub";
        this.admin.namespaces().createNamespace("external-repl-prop/io");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"}));
        this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
        FunctionConfig functionConfig = PulsarFunctionPublishTest.createFunctionConfig("external-repl-prop", "io", "PulsarFunction-test", "persistent://external-repl-prop/io/input", "persistent://external-repl-prop/io/publishtopic", "test-sub");
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        AuthenticationTls authTls = new AuthenticationTls();
        authTls.configure(authParams);
        String secondAddress = this.pulsar.getWebServiceAddressTls().replace("https://", "");
        PulsarAdmin pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.pulsar.getWebServiceAddressTls() + "," + secondAddress).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(true).authentication((Authentication)authTls).build();
        File jarFile = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar();
        Assert.assertTrue((jarFile.exists() && jarFile.isFile() ? 1 : 0) != 0);
        pulsarAdmin.functions().createFunction(functionConfig, jarFile.getAbsolutePath());
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 1;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        Assert.assertEquals((int)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size(), (int)1);
        this.admin.functions().deleteFunction("external-repl-prop", "io", "PulsarFunction-test");
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 0;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
    }

    @Test(timeOut=20000L)
    public void testPulsarFunctionBKCleanup() throws Exception {
        int i;
        String namespacePortion = "io";
        String replNamespace = "external-repl-prop/io";
        String sourceTopic = "persistent://external-repl-prop/io/input";
        String publishTopic = "persistent://external-repl-prop/io/publishtopic";
        String propertyKey = "key";
        String propertyValue = "value";
        String functionName = "PulsarFunction-test";
        String subscriptionName = "test-sub";
        this.admin.namespaces().createNamespace("external-repl-prop/io");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"}));
        this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/io/input").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://external-repl-prop/io/publishtopic"}).subscriptionName("sub").subscribe();
        FunctionConfig functionConfig = PulsarFunctionPublishTest.createFunctionConfig("external-repl-prop", "io", "PulsarFunction-test", "persistent://external-repl-prop/io/input", "persistent://external-repl-prop/io/publishtopic", "test-sub");
        File jarFile = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar();
        Assert.assertTrue((jarFile.exists() && jarFile.isFile() ? 1 : 0) != 0);
        this.admin.functions().createFunction(functionConfig, jarFile.getAbsolutePath());
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 1;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        Assert.assertEquals((int)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size(), (int)1);
        int totalMsgs = 5;
        for (i = 0; i < totalMsgs; ++i) {
            String data = "foo";
            producer.newMessage().property("key", "value").key(String.valueOf(i)).value((Object)data).send();
        }
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                SubscriptionStats subStats = (SubscriptionStats)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().get("test-sub");
                return subStats.getUnackedMessages() == 0L;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                FunctionStatsImpl functionStat = (FunctionStatsImpl)this.admin.functions().getFunctionStats("external-repl-prop", "io", "PulsarFunction-test");
                return functionStat.getProcessedSuccessfullyTotal() == 5L;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        for (i = 0; i < 5; ++i) {
            Message msg = consumer.receive(5, TimeUnit.SECONDS);
            String receivedPropertyValue = msg.getProperty("key");
            Assert.assertEquals((String)"value", (String)receivedPropertyValue);
            Assert.assertEquals((String)msg.getProperty("input_topic"), (String)"persistent://external-repl-prop/io/input");
            Assert.assertEquals((String)msg.getKey(), (String)String.valueOf(i));
        }
        Assert.assertNotEquals((Object)((SubscriptionStats)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().values().iterator().next()).getUnackedMessages(), (Object)totalMsgs);
        this.admin.functions().deleteFunction("external-repl-prop", "io", "PulsarFunction-test");
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                return this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size() == 0;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 50, 150L);
        Assert.assertEquals((int)this.admin.topics().getStats("persistent://external-repl-prop/io/input").getSubscriptions().size(), (int)0);
        this.tempDirectory.assertThatFunctionDownloadTempFilesHaveBeenDeleted();
        DistributedLogConfiguration dlogConf = WorkerUtils.getDlogConf((WorkerConfig)this.workerConfig);
        String url = String.format("distributedlog://%s/pulsar/functions", "127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        log.info("dlog url: {}", (Object)url);
        URI dlogUri = URI.create(url);
        Namespace dlogNamespace = NamespaceBuilder.newBuilder().conf(dlogConf).clientId("function-worker-" + this.workerConfig.getWorkerId()).uri(dlogUri).build();
        final LinkedList files = new LinkedList();
        dlogNamespace.getLogs(String.format("%s/%s/%s", "external-repl-prop", "io", "PulsarFunction-test")).forEachRemaining(new java.util.function.Consumer<String>(){

            @Override
            public void accept(String s) {
                files.add(s);
            }
        });
        Assert.assertEquals((int)files.size(), (int)0, (String)("BK files left over: " + files));
    }

    @Test
    public void testUpdateFunctionUserConfig() throws Exception {
        String namespacePortion = "io";
        String replNamespace = "external-repl-prop/io";
        String sourceTopic = "persistent://external-repl-prop/io/input";
        String publishTopic = "persistent://external-repl-prop/io/publishtopic";
        String functionName = "test-update-user-config";
        String subscriptionName = "test-sub";
        this.admin.namespaces().createNamespace("external-repl-prop/io");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"}));
        this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
        FunctionConfig functionConfig = PulsarFunctionPublishTest.createFunctionConfig("external-repl-prop", "io", "test-update-user-config", "persistent://external-repl-prop/io/input", "persistent://external-repl-prop/io/publishtopic", "test-sub");
        String jarFilePathUrl = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar().toURI().toString();
        this.admin.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
        Map userConfig = functionConfig.getUserConfig();
        functionConfig.setUserConfig(null);
        this.admin.functions().updateFunctionWithUrl(functionConfig, jarFilePathUrl);
        FunctionConfig updatefunctionConfig1 = this.admin.functions().getFunction("external-repl-prop", "io", "test-update-user-config");
        Assert.assertEquals((Map)userConfig, (Map)updatefunctionConfig1.getUserConfig());
        HashMap<String, String> newUserConfig = new HashMap<String, String>();
        newUserConfig.put("publish-topic", "persistent://external-repl-prop/io/publishtopic");
        newUserConfig.put("test", "test");
        updatefunctionConfig1.setUserConfig(newUserConfig);
        this.admin.functions().updateFunctionWithUrl(updatefunctionConfig1, jarFilePathUrl);
        FunctionConfig updatefunctionConfig2 = this.admin.functions().getFunction("external-repl-prop", "io", "test-update-user-config");
        Assert.assertEquals((Map)updatefunctionConfig2.getUserConfig(), (Map)updatefunctionConfig1.getUserConfig());
    }
}

