/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import org.apache.pulsar.broker.transaction.util.LogIndexLagBackoff;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"utils"})
public class LogIndexLagBackOffTest {
    @Test
    public void testGenerateNextLogIndexLag() {
        LogIndexLagBackoff logIndexLagBackoff = new LogIndexLagBackoff(1L, 10L, 1.0);
        Assert.assertEquals((long)logIndexLagBackoff.next(0), (long)1L);
        Assert.assertEquals((long)logIndexLagBackoff.next(6), (long)6L);
        Assert.assertEquals((long)logIndexLagBackoff.next(77), (long)10L);
        logIndexLagBackoff = new LogIndexLagBackoff(1L, 10L, 2.0);
        Assert.assertEquals((long)logIndexLagBackoff.next(3), (long)9L);
        try {
            new LogIndexLagBackoff(-1L, 2L, 3.0);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"min lag must be > 0");
        }
        try {
            new LogIndexLagBackoff(2L, 1L, 3.0);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"maxLag should be >= minLag");
        }
        try {
            new LogIndexLagBackoff(1L, 1L, 0.2);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"exponent must be > 0");
        }
    }
}

