/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.utils.StatsOutputStream;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"utils"})
public class StatsOutputStreamTest {
    private ByteBuf buf;
    private StatsOutputStream stream;

    @BeforeMethod
    public void reset() {
        this.buf = Unpooled.buffer((int)4096);
        this.stream = new StatsOutputStream(this.buf);
    }

    @Test
    public void testPairs() {
        this.stream.writePair("my-count", 1L);
        Assert.assertEquals((String)this.str(), (String)"\"my-count\":1");
        this.stream.writePair("my-rate", 0.0);
        Assert.assertEquals((String)this.str(), (String)"\"my-rate\":0.0");
        this.stream.writePair("my-flag", true);
        Assert.assertEquals((String)this.str(), (String)"\"my-flag\":true");
        this.stream.writePair("my-string", "value");
        Assert.assertEquals((String)this.str(), (String)"\"my-string\":\"value\"");
    }

    @Test
    public void testLists() {
        this.stream.startList();
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[]");
        this.stream.startList();
        this.stream.writeItem(1L);
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[1]");
        this.stream.startList();
        this.stream.writeItem(1L).writeItem(2L);
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[1,2]");
        this.stream.startList();
        this.stream.writeItem(1L).writeItem(2L).writeItem(3L);
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[1,2,3]");
        this.stream.startList();
        this.stream.writeItem(1L).writeItem(2L).writeItem(3L).writeItem(false).writeItem(1.0).writeItem("xyz");
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[1,2,3,false,1.0,\"xyz\"]");
    }

    @Test
    public void testNamedLists() {
        this.stream.startList("abc");
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"\"abc\":[]");
        this.stream.startList("abc");
        this.stream.writeItem(1L);
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"\"abc\":[1]");
    }

    @Test
    public void testObjects() {
        this.stream.startObject();
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"{}");
        this.stream.startObject();
        this.stream.writePair("a", 1L);
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"{\"a\":1}");
        this.stream.startObject();
        this.stream.writePair("a", 1L).writePair("b", 2L);
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"{\"a\":1,\"b\":2}");
        this.stream.startObject();
        this.stream.writePair("a", 1L).writePair("b", 2L).writePair("c", 3L);
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"{\"a\":1,\"b\":2,\"c\":3}");
    }

    @Test
    public void testNamedObjects() {
        this.stream.startObject("abc");
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"\"abc\":{}");
        this.stream.startObject("abc");
        this.stream.writePair("a", 1L);
        this.stream.endObject();
        Assert.assertEquals((String)this.str(), (String)"\"abc\":{\"a\":1}");
    }

    @Test
    public void testNestedObjects() {
        this.stream.startList();
        this.stream.startObject();
        this.stream.writePair("a", 1L);
        this.stream.endObject();
        this.stream.startObject();
        this.stream.writePair("b", 2L);
        this.stream.endObject();
        this.stream.endList();
        Assert.assertEquals((String)this.str(), (String)"[{\"a\":1},{\"b\":2}]");
    }

    public String str() {
        String s = this.buf.toString(StandardCharsets.UTF_8);
        this.reset();
        return s;
    }
}

