/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import java.util.Optional;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"websocket"})
public class ProxyConfigurationTest
extends ProducerConsumerBase {
    private WebSocketProxyConfiguration config;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.config = new WebSocketProxyConfiguration();
        this.config.setWebServicePort(Optional.of(0));
        this.config.setClusterName("test");
        this.config.setConfigurationStoreServers("GLOBAL_DUMMY_VALUE");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="setProxyConfig")
    public Object[][] setProxyConfig() {
        return new Object[][]{{2, 1}, {4, 2}};
    }

    @Test(dataProvider="setProxyConfig", timeOut=10000L)
    public void configTest(int numIoThreads, int connectionsPerBroker) throws Exception {
        this.config.setWebSocketNumIoThreads(numIoThreads);
        this.config.setWebSocketConnectionsPerBroker(connectionsPerBroker);
        this.config.getProperties().setProperty("brokerClient_serviceUrl", "https://broker.com:8080");
        this.config.setServiceUrl("http://localhost:8080");
        this.config.getProperties().setProperty("brokerClient_lookupTimeoutMs", "100");
        WebSocketService service = BrokerTestUtil.spyWithClassAndConstructorArgs(WebSocketService.class, this.config);
        ((WebSocketService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)this.mockZooKeeperGlobal)).when((Object)service)).createMetadataStore(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        service.start();
        PulsarClientImpl client = (PulsarClientImpl)service.getPulsarClient();
        Assert.assertEquals((int)client.getConfiguration().getNumIoThreads(), (int)numIoThreads);
        Assert.assertEquals((int)client.getConfiguration().getConnectionsPerBroker(), (int)connectionsPerBroker);
        Assert.assertEquals((String)client.getConfiguration().getServiceUrl(), (String)"http://localhost:8080", (String)"brokerClient_ configs take precedence");
        Assert.assertEquals((long)client.getConfiguration().getLookupTimeoutMs(), (long)100L);
        service.close();
    }
}

