/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.websocket.data.ProducerMessage;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class SimpleProducerSocket {
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private Session session;
    private final ArrayList<String> producerBuffer = new ArrayList();
    private final int messagesToSendWhenConnected;
    private static final Logger log = LoggerFactory.getLogger(SimpleProducerSocket.class);

    public SimpleProducerSocket() {
        this(10);
    }

    public SimpleProducerSocket(int messagesToSendWhenConnected) {
        this.messagesToSendWhenConnected = messagesToSendWhenConnected;
    }

    private static String getTestJsonPayload(int index) throws JsonProcessingException {
        ProducerMessage msg = new ProducerMessage();
        msg.payload = Base64.getEncoder().encodeToString(("test" + index).getBytes());
        msg.key = Integer.toString(index);
        return AdminResource.jsonMapper().writeValueAsString((Object)msg);
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        log.info("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
        this.session = null;
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) throws Exception {
        log.info("Got connect: {}", (Object)session);
        this.session = session;
        this.sendMessage(this.messagesToSendWhenConnected);
    }

    public void sendMessage(int totalMsgs) throws Exception {
        for (int i = 0; i < totalMsgs; ++i) {
            this.session.getRemote().sendString(SimpleProducerSocket.getTestJsonPayload(i));
        }
    }

    @OnWebSocketMessage
    public synchronized void onMessage(String msg) throws JsonParseException {
        JsonObject ack = (JsonObject)new Gson().fromJson(msg, JsonObject.class);
        this.producerBuffer.add(ack.get("messageId").getAsString());
    }

    public RemoteEndpoint getRemote() {
        return this.session.getRemote();
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized ArrayList<String> getBuffer() {
        return this.producerBuffer;
    }
}

