/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ObjectCache;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final boolean tlsEnabledWithKeyStore;
    private final Supplier<SslContext> sslContextSupplier;
    private NettySSLContextAutoRefreshBuilder nettySSLContextAutoRefreshBuilder;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.tlsEnabledWithKeyStore = conf.isUseKeyStoreTls();
        if (this.tlsEnabled) {
            if (this.tlsEnabledWithKeyStore) {
                AuthenticationDataProvider authData1 = conf.getAuthentication().getAuthData();
                this.nettySSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(conf.getSslProvider(), conf.isTlsAllowInsecureConnection(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols(), TLS_CERTIFICATE_CACHE_MILLIS, authData1);
            }
            this.sslContextSupplier = new ObjectCache<SslContext>(() -> {
                try {
                    AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
                    if (authData.hasDataForTls()) {
                        return authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient((boolean)conf.isTlsAllowInsecureConnection(), (String)conf.getTlsTrustCertsFilePath(), (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient((boolean)conf.isTlsAllowInsecureConnection(), (InputStream)authData.getTlsTrustStoreStream(), (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey());
                    }
                    return SecurityUtility.createNettySslContextForClient((boolean)conf.isTlsAllowInsecureConnection(), (String)conf.getTlsTrustCertsFilePath());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create TLS context", e);
                }
            }, TLS_CERTIFICATE_CACHE_MILLIS, TimeUnit.MILLISECONDS);
        } else {
            this.sslContextSupplier = null;
        }
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)(this.tlsEnabled ? ByteBufPair.COPYING_ENCODER : ByteBufPair.ENCODER));
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)this.clientCnxSupplier.get());
    }

    CompletableFuture<Channel> initTls(Channel ch, InetSocketAddress sniHost) {
        Objects.requireNonNull(ch, "A channel is required");
        Objects.requireNonNull(sniHost, "A sniHost is required");
        if (!this.tlsEnabled) {
            throw new IllegalStateException("TLS is not enabled in client configuration");
        }
        CompletableFuture<Channel> initTlsFuture = new CompletableFuture<Channel>();
        ch.eventLoop().execute(() -> {
            try {
                SslHandler handler = this.tlsEnabledWithKeyStore ? new SslHandler(((KeyStoreSSLContext)this.nettySSLContextAutoRefreshBuilder.get()).createSSLEngine(sniHost.getHostString(), sniHost.getPort())) : this.sslContextSupplier.get().newHandler(ch.alloc(), sniHost.getHostString(), sniHost.getPort());
                ch.pipeline().addFirst(TLS_HANDLER, (ChannelHandler)handler);
                initTlsFuture.complete(ch);
            }
            catch (Throwable t) {
                initTlsFuture.completeExceptionally(t);
            }
        });
        return initTlsFuture;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }
}

