/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorsManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsManager.class);
    private volatile TreeMap<String, Connector> connectors;

    public ConnectorsManager(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors((String)workerConfig.getConnectorsDirectory(), (String)workerConfig.getNarExtractionDirectory());
    }

    public Connector getConnector(String connectorType) {
        return this.connectors.get(connectorType);
    }

    public ConnectorDefinition getConnectorDefinition(String connectorType) {
        return this.connectors.get(connectorType).getConnectorDefinition();
    }

    public List<ConnectorDefinition> getConnectorDefinitions() {
        return this.connectors.values().stream().map(connector -> connector.getConnectorDefinition()).collect(Collectors.toList());
    }

    public Path getSourceArchive(String sourceType) {
        return this.connectors.get(sourceType).getArchivePath();
    }

    public List<ConfigFieldDefinition> getSourceConfigDefinition(String sourceType) {
        return this.connectors.get(sourceType).getSourceConfigFieldDefinitions();
    }

    public List<ConfigFieldDefinition> getSinkConfigDefinition(String sinkType) {
        return this.connectors.get(sinkType).getSinkConfigFieldDefinitions();
    }

    public Path getSinkArchive(String sinkType) {
        return this.connectors.get(sinkType).getArchivePath();
    }

    public void reloadConnectors(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors((String)workerConfig.getConnectorsDirectory(), (String)workerConfig.getNarExtractionDirectory());
    }

    public TreeMap<String, Connector> getConnectors() {
        return this.connectors;
    }
}

