/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.collect.Sets;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.proxy.extensions.ProxyExtensions;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ServiceChannelInitializer;
import org.apache.pulsar.proxy.stats.TopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyService
implements Closeable {
    private final ProxyConfiguration proxyConfig;
    private final Authentication proxyClientAuthentication;
    private final Timer timer;
    private String serviceUrl;
    private String serviceUrlTls;
    private final AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private MetadataStoreExtended localMetadataStore;
    private MetadataStoreExtended configMetadataStore;
    private PulsarResources pulsarResources;
    private ProxyExtensions proxyExtensions = null;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private Channel listenChannel;
    private Channel listenChannelTls;
    private final DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-proxy-acceptor");
    private final DefaultThreadFactory workersThreadFactory = new DefaultThreadFactory("pulsar-proxy-io");
    private BrokerDiscoveryProvider discoveryProvider;
    protected final AtomicReference<Semaphore> lookupRequestSemaphore;
    protected int proxyLogLevel;
    private final ScheduledExecutorService statsExecutor;
    private static final int numThreads = Runtime.getRuntime().availableProcessors();
    static final Gauge activeConnections = (Gauge)Gauge.build((String)"pulsar_proxy_active_connections", (String)"Number of connections currently active in the proxy").create().register();
    static final Counter newConnections = (Counter)Counter.build((String)"pulsar_proxy_new_connections", (String)"Counter of connections being opened in the proxy").create().register();
    static final Counter rejectedConnections = (Counter)Counter.build((String)"pulsar_proxy_rejected_connections", (String)"Counter for connections rejected due to throttling").create().register();
    static final Counter opsCounter = (Counter)Counter.build((String)"pulsar_proxy_binary_ops", (String)"Counter of proxy operations").create().register();
    static final Counter bytesCounter = (Counter)Counter.build((String)"pulsar_proxy_binary_bytes", (String)"Counter of proxy bytes").create().register();
    private final Set<ProxyConnection> clientCnxs;
    private final Map<String, TopicStats> topicStats;
    private AdditionalServlets proxyAdditionalServlets;
    private static final Logger LOG = LoggerFactory.getLogger(ProxyService.class);

    public ProxyService(ProxyConfiguration proxyConfig, AuthenticationService authenticationService) throws Exception {
        Objects.requireNonNull(proxyConfig);
        this.proxyConfig = proxyConfig;
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("pulsar-timer", Thread.currentThread().isDaemon()), 1L, TimeUnit.MILLISECONDS);
        this.clientCnxs = Sets.newConcurrentHashSet();
        this.topicStats = new ConcurrentHashMap<String, TopicStats>();
        this.lookupRequestSemaphore = new AtomicReference<Semaphore>(new Semaphore(proxyConfig.getMaxConcurrentLookupRequests(), false));
        this.proxyLogLevel = proxyConfig.getProxyLogLevel().isPresent() ? proxyConfig.getProxyLogLevel().get() : 0;
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)numThreads, (boolean)false, (ThreadFactory)this.workersThreadFactory);
        this.authenticationService = authenticationService;
        this.proxyExtensions = ProxyExtensions.load(proxyConfig);
        this.proxyExtensions.initialize(proxyConfig);
        this.statsExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("proxy-stats-executor"));
        this.statsExecutor.schedule(() -> {
            this.clientCnxs.forEach(cnx -> {
                if (cnx.getDirectProxyHandler() != null && cnx.getDirectProxyHandler().getInboundChannelRequestsRate() != null) {
                    cnx.getDirectProxyHandler().getInboundChannelRequestsRate().calculateRate();
                }
            });
            this.topicStats.forEach((topic, stats) -> stats.calculate());
        }, 60L, TimeUnit.SECONDS);
        this.proxyAdditionalServlets = AdditionalServlets.load((PulsarConfiguration)proxyConfig);
        this.proxyClientAuthentication = proxyConfig.getBrokerClientAuthenticationPlugin() != null ? AuthenticationFactory.create((String)proxyConfig.getBrokerClientAuthenticationPlugin(), (String)proxyConfig.getBrokerClientAuthenticationParameters()) : AuthenticationDisabled.INSTANCE;
    }

    public void start() throws Exception {
        if (this.proxyConfig.isAuthorizationEnabled() && !this.proxyConfig.isAuthenticationEnabled()) {
            throw new IllegalStateException("Invalid proxy configuration. Authentication must be enabled with authenticationEnabled=true when authorization is enabled with authorizationEnabled=true.");
        }
        if (!StringUtils.isBlank((CharSequence)this.proxyConfig.getZookeeperServers()) && !StringUtils.isBlank((CharSequence)this.proxyConfig.getConfigurationStoreServers())) {
            this.localMetadataStore = this.createLocalMetadataStore();
            this.configMetadataStore = this.createConfigurationMetadataStore();
            this.pulsarResources = new PulsarResources((MetadataStore)this.localMetadataStore, (MetadataStore)this.configMetadataStore);
            this.discoveryProvider = new BrokerDiscoveryProvider(this.proxyConfig, this.pulsarResources);
            this.authorizationService = new AuthorizationService(PulsarConfigurationLoader.convertFrom((PulsarConfiguration)this.proxyConfig), this.pulsarResources);
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PulsarByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        bootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, false));
        if (this.proxyConfig.getServicePort().isPresent()) {
            try {
                this.listenChannel = bootstrap.bind(this.proxyConfig.getBindAddress(), this.proxyConfig.getServicePort().get().intValue()).sync().channel();
                LOG.info("Started Pulsar Proxy at {}", (Object)this.listenChannel.localAddress());
            }
            catch (Exception e) {
                throw new IOException("Failed to bind Pulsar Proxy on port " + this.proxyConfig.getServicePort().get(), e);
            }
        }
        if (this.proxyConfig.getServicePortTls().isPresent()) {
            ServerBootstrap tlsBootstrap = bootstrap.clone();
            tlsBootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.proxyConfig, true));
            this.listenChannelTls = tlsBootstrap.bind(this.proxyConfig.getBindAddress(), this.proxyConfig.getServicePortTls().get().intValue()).sync().channel();
            LOG.info("Started Pulsar TLS Proxy on {}", (Object)this.listenChannelTls.localAddress());
        }
        String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)this.proxyConfig.getAdvertisedAddress());
        this.serviceUrl = this.proxyConfig.getServicePort().isPresent() ? String.format("pulsar://%s:%d/", hostname, this.getListenPort().get()) : null;
        this.serviceUrlTls = this.proxyConfig.getServicePortTls().isPresent() ? String.format("pulsar+ssl://%s:%d/", hostname, this.getListenPortTls().get()) : null;
        this.proxyExtensions.start(this);
        Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> protocolHandlerChannelInitializers = this.proxyExtensions.newChannelInitializers();
        this.startProxyExtensions(protocolHandlerChannelInitializers, bootstrap);
    }

    public void startProxyExtensions(Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> protocolHandlers, ServerBootstrap serverBootstrap) {
        protocolHandlers.forEach((extensionName, initializers) -> initializers.forEach((address, initializer) -> {
            try {
                this.startProxyExtension((String)extensionName, (SocketAddress)address, (ChannelInitializer<SocketChannel>)initializer, serverBootstrap);
            }
            catch (IOException e) {
                LOG.error("{}", (Object)e.getMessage(), (Object)e.getCause());
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
        }));
    }

    private void startProxyExtension(String extensionName, SocketAddress address, ChannelInitializer<SocketChannel> initializer, ServerBootstrap serverBootstrap) throws IOException {
        ServerBootstrap bootstrap = serverBootstrap.clone();
        bootstrap.childHandler(initializer);
        try {
            bootstrap.bind(address).sync();
        }
        catch (Exception e) {
            throw new IOException("Failed to bind extension `" + extensionName + "` on " + address, e);
        }
        LOG.info("Successfully bound extension `{}` on {}", (Object)extensionName, (Object)address);
    }

    public BrokerDiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.discoveryProvider != null) {
            this.discoveryProvider.close();
        }
        if (this.listenChannel != null) {
            this.listenChannel.close();
        }
        if (this.listenChannelTls != null) {
            this.listenChannelTls.close();
        }
        if (this.statsExecutor != null) {
            this.statsExecutor.shutdown();
        }
        if (this.proxyAdditionalServlets != null) {
            this.proxyAdditionalServlets.close();
            this.proxyAdditionalServlets = null;
        }
        if (this.localMetadataStore != null) {
            try {
                this.localMetadataStore.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.configMetadataStore != null) {
            try {
                this.configMetadataStore.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.acceptorGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public ProxyConfiguration getConfiguration() {
        return this.proxyConfig;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public Semaphore getLookupRequestSemaphore() {
        return this.lookupRequestSemaphore.get();
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public Optional<Integer> getListenPort() {
        if (this.listenChannel != null) {
            return Optional.of(((InetSocketAddress)this.listenChannel.localAddress()).getPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortTls() {
        if (this.listenChannelTls != null) {
            return Optional.of(((InetSocketAddress)this.listenChannelTls.localAddress()).getPort());
        }
        return Optional.empty();
    }

    public MetadataStoreExtended createLocalMetadataStore() throws MetadataStoreException {
        return PulsarResources.createMetadataStore((String)this.proxyConfig.getZookeeperServers(), (int)this.proxyConfig.getZookeeperSessionTimeoutMs());
    }

    public MetadataStoreExtended createConfigurationMetadataStore() throws MetadataStoreException {
        return PulsarResources.createMetadataStore((String)this.proxyConfig.getConfigurationStoreServers(), (int)this.proxyConfig.getZookeeperSessionTimeoutMs());
    }

    public Authentication getProxyClientAuthenticationPlugin() {
        return this.proxyClientAuthentication;
    }

    public int getProxyLogLevel() {
        return this.proxyLogLevel;
    }

    public void setProxyLogLevel(int proxyLogLevel) {
        this.proxyLogLevel = proxyLogLevel;
    }

    public Set<ProxyConnection> getClientCnxs() {
        return this.clientCnxs;
    }

    public Map<String, TopicStats> getTopicStats() {
        return this.topicStats;
    }

    public AdditionalServlets getProxyAdditionalServlets() {
        return this.proxyAdditionalServlets;
    }
}

