/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.stats;

import io.netty.channel.Channel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.pulsar.proxy.server.ProxyService;
import org.apache.pulsar.proxy.stats.ConnectionStats;
import org.apache.pulsar.proxy.stats.RestException;
import org.apache.pulsar.proxy.stats.TopicStats;

@Path(value="/")
@Api(value="/proxy-stats", description="Stats for proxy", tags={"proxy-stats"}, hidden=true)
@Produces(value={"application/json"})
public class ProxyStats {
    public static final String ATTRIBUTE_PULSAR_PROXY_NAME = "pulsar-proxy";
    private ProxyService service;
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/connections")
    @ApiOperation(value="Proxy stats api to get info for live connections", response=List.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=503, message="Proxy service is not initialized")})
    public List<ConnectionStats> metrics() {
        ArrayList<ConnectionStats> stats = new ArrayList<ConnectionStats>();
        this.proxyService().getClientCnxs().forEach(cnx -> {
            if (cnx.getDirectProxyHandler() == null) {
                return;
            }
            double requestRate = cnx.getDirectProxyHandler().getInboundChannelRequestsRate().getRate();
            double byteRate = cnx.getDirectProxyHandler().getInboundChannelRequestsRate().getValueRate();
            Channel inboundChannel = cnx.getDirectProxyHandler().getInboundChannel();
            Channel outboundChannel = cnx.getDirectProxyHandler().getOutboundChannel();
            stats.add(new ConnectionStats(requestRate, byteRate, inboundChannel, outboundChannel));
        });
        return stats;
    }

    @GET
    @Path(value="/topics")
    @ApiOperation(value="Proxy topic stats api", response=Map.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=412, message="Proxy logging should be > 2 to capture topic stats"), @ApiResponse(code=503, message="Proxy service is not initialized")})
    public Map<String, TopicStats> topics() {
        Optional<Integer> logLevel = this.proxyService().getConfiguration().getProxyLogLevel();
        if (!logLevel.isPresent() || logLevel.get() < 2) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Proxy doesn't have logging level 2");
        }
        return this.proxyService().getTopicStats();
    }

    @POST
    @Path(value="/logging/{logLevel}")
    @ApiOperation(hidden=true, value="Change proxy logging level dynamically", notes="It only changes log-level in memory, change it config file to persist the change")
    @ApiResponses(value={@ApiResponse(code=412, message="Proxy log level can be [0-2]")})
    public void updateProxyLogLevel(@PathParam(value="logLevel") int logLevel) {
        if (logLevel < 0 || logLevel > 2) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Proxy log level can be only [0-2]");
        }
        this.proxyService().setProxyLogLevel(logLevel);
    }

    @GET
    @Path(value="/logging")
    @ApiOperation(hidden=true, value="Get proxy logging")
    public int getProxyLogLevel(@PathParam(value="logLevel") int logLevel) {
        return this.proxyService().getProxyLogLevel();
    }

    protected ProxyService proxyService() {
        if (this.service == null) {
            this.service = (ProxyService)this.servletContext.getAttribute(ATTRIBUTE_PULSAR_PROXY_NAME);
            if (this.service == null) {
                throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Proxy service is not initialized");
            }
        }
        return this.service;
    }
}

