/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Container
extends ChaosContainer<S3Container> {
    private static final Logger log = LoggerFactory.getLogger(S3Container.class);
    public static final String NAME = "s3";
    private static final String IMAGE_NAME = "apachepulsar/s3mock:latest";
    private final String hostname;

    public S3Container(String clusterName, String hostname) {
        super(clusterName, IMAGE_NAME);
        this.hostname = hostname;
        this.withEnv("initialBuckets", "pulsar-integtest");
    }

    public String getContainerName() {
        return this.clusterName + "-" + this.hostname;
    }

    public void start() {
        this.withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(this.hostname);
            createContainerCmd.withName(this.getContainerName());
        });
        super.start();
        log.info("Start s3 service");
    }
}

