/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.utils.DockerUtils;

public class ZKContainer<SelfT extends PulsarContainer<SelfT>>
extends PulsarContainer<SelfT> {
    public static final String NAME = "zookeeper";
    private volatile boolean dumpZkDataBeforeStop = false;

    public ZKContainer(String clusterName) {
        super(clusterName, NAME, NAME, "bin/run-local-zk.sh", 2181, -1);
    }

    public ZKContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort) {
        super(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, httpPort);
    }

    public void enableDumpZkDataBeforeStop(boolean enabled) {
        this.dumpZkDataBeforeStop = enabled;
    }

    @Override
    protected void beforeStop() {
        super.beforeStop();
        if (null != this.getContainerId() && this.dumpZkDataBeforeStop) {
            DockerUtils.dumpContainerDirToTargetCompressed(this.getDockerClient(), this.getContainerId(), "/pulsar/data/zookeeper");
        }
    }
}

