/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions.utils;

public class UploadDownloadCommandGenerator {
    private MODE mode;
    private String bkPath;
    private String localPath;
    private String brokerUrl;

    public static UploadDownloadCommandGenerator createUploader(String localPath, String bkPath) {
        return new UploadDownloadCommandGenerator(MODE.UPLOAD, localPath, bkPath);
    }

    public static UploadDownloadCommandGenerator createDownloader(String localPath, String bkPath) {
        return new UploadDownloadCommandGenerator(MODE.DOWNLOAD, localPath, bkPath);
    }

    public UploadDownloadCommandGenerator(MODE mode, String localPath, String bkPath) {
        this.mode = mode;
        this.localPath = localPath;
        this.bkPath = bkPath;
    }

    public void createBrokerUrl(String host, int port) {
        this.brokerUrl = "pulsar://" + host + ":" + port;
    }

    public String generateCommand() {
        StringBuilder commandBuilder = new StringBuilder().append("/pulsar/bin/pulsar-admin").append(" functions ");
        if (this.mode == MODE.UPLOAD) {
            commandBuilder.append(" upload ");
        } else {
            commandBuilder.append(" download ");
        }
        commandBuilder.append(" --path ");
        commandBuilder.append(this.bkPath);
        if (this.mode == MODE.UPLOAD) {
            commandBuilder.append(" --sourceFile ");
        } else {
            commandBuilder.append(" --destinationFile ");
        }
        commandBuilder.append(this.localPath);
        return commandBuilder.toString();
    }

    public MODE getMode() {
        return this.mode;
    }

    public String getBkPath() {
        return this.bkPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public void setBkPath(String bkPath) {
        this.bkPath = bkPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String toString() {
        return "UploadDownloadCommandGenerator(mode=" + (Object)((Object)this.getMode()) + ", bkPath=" + this.getBkPath() + ", localPath=" + this.getLocalPath() + ", brokerUrl=" + this.getBrokerUrl() + ")";
    }

    public static enum MODE {
        UPLOAD,
        DOWNLOAD;

    }
}

