/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.tests.integration.containers.StandaloneContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarStandaloneTestSuite;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BatchSourceTest
extends PulsarStandaloneTestSuite {
    private static final Logger log = LoggerFactory.getLogger(BatchSourceTest.class);
    private static final String BATCH_CONFIG = "{\"discoveryTriggererConfig\": {\"__CRON__\": \"* * * * * *\"}, \"discoveryTriggererClassName\": \"org.apache.pulsar.io.batchdiscovery.CronTriggerer\"}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"source"})
    public void testGenericRecordSource() throws Exception {
        String outputTopicName = "test-state-source-output-" + BatchSourceTest.randomName(8);
        String sourceName = "test-state-source-" + BatchSourceTest.randomName(8);
        int numMessages = 10;
        try {
            this.submitSourceConnector(sourceName, outputTopicName, "builtin://batch-data-generator");
            BatchSourceTest.getSourceInfoSuccess(this.container, sourceName);
            BatchSourceTest.getSourceStatus(this.container, sourceName);
            try (PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.container.getHttpServiceUrl()).build();){
                PulsarTestSuite.retryStrategically(test -> {
                    try {
                        SourceStatus status = admin.sources().getSourceStatus("public", "default", sourceName);
                        return status.getInstances().size() > 0 && ((SourceStatus.SourceInstanceStatus)status.getInstances().get((int)0)).getStatus().numWritten >= 10L;
                    }
                    catch (PulsarAdminException e) {
                        return false;
                    }
                }, 10, 200L);
                SourceStatus status = admin.sources().getSourceStatus("public", "default", sourceName);
                Assert.assertEquals((int)status.getInstances().size(), (int)1);
                Assert.assertTrue((((SourceStatus.SourceInstanceStatus)status.getInstances().get((int)0)).getStatus().numWritten >= 10L ? 1 : 0) != 0);
            }
            BatchSourceTest.consumeMessages(this.container, outputTopicName, numMessages);
            BatchSourceTest.deleteSource(this.container, sourceName);
            BatchSourceTest.getSourceInfoNotFound(this.container, sourceName);
        }
        finally {
            this.dumpFunctionLogs(sourceName);
        }
    }

    private void submitSourceConnector(String sourceName, String outputTopicName, String archive) throws Exception {
        Object[] commands = new String[]{"/pulsar/bin/pulsar-admin", "sources", "create", "--name", sourceName, "--destinationTopicName", outputTopicName, "--archive", archive, "--batch-source-config", BATCH_CONFIG};
        log.info("Run command : {}", (Object)StringUtils.join((Object[])commands, (char)' '));
        ContainerExecResult result = this.container.execCmd((String[])commands);
        Assert.assertTrue((boolean)result.getStdout().contains("\"Created successfully\""), (String)result.getStdout());
    }

    private static void getSourceInfoSuccess(StandaloneContainer container, String sourceName) throws Exception {
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "sources", "get", "--tenant", "public", "--namespace", "default", "--name", sourceName);
        Assert.assertTrue((boolean)result.getStdout().contains("\"name\": \"" + sourceName + "\""));
    }

    private static void getSourceStatus(StandaloneContainer container, String sourceName) throws Exception {
        PulsarTestSuite.retryStrategically(test -> {
            try {
                ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "sources", "status", "--tenant", "public", "--namespace", "default", "--name", sourceName);
                return result.getStdout().contains("\"running\" : true");
            }
            catch (Exception e) {
                log.error("Encountered error when getting source status", (Throwable)e);
                return false;
            }
        }, 10, 200L);
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "sources", "status", "--tenant", "public", "--namespace", "default", "--name", sourceName);
        Assert.assertTrue((boolean)result.getStdout().contains("\"running\" : true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void consumeMessages(StandaloneContainer container, String outputTopic, int numMessages) throws Exception {
        PulsarClient client = PulsarClient.builder().serviceUrl(container.getPlainTextServiceUrl()).build();
        try {
            Consumer consumer = client.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{outputTopic}).subscriptionType(SubscriptionType.Exclusive).subscriptionName("test-sub").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).startMessageIdInclusive().subscribe();
            try {
                int i = 0;
                while (true) {
                    if (i < numMessages) {
                        Message msg = consumer.receive(10, TimeUnit.SECONDS);
                        if (msg == null) {
                            Assert.fail((String)("message " + i + " not received in time"));
                            return;
                        }
                        log.info("received {}", msg.getValue());
                        ((GenericRecord)msg.getValue()).getFields().forEach(f -> log.info("field {} {}", f, ((GenericRecord)msg.getValue()).getField(f)));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private static void deleteSource(StandaloneContainer container, String sourceName) throws Exception {
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "sources", "delete", "--tenant", "public", "--namespace", "default", "--name", sourceName);
        Assert.assertTrue((boolean)result.getStdout().contains("Delete source successfully"));
        Assert.assertTrue((boolean)result.getStderr().isEmpty());
    }

    private static void getSourceInfoNotFound(StandaloneContainer container, String sourceName) throws Exception {
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "sources", "get", "--tenant", "public", "--namespace", "default", "--name", sourceName);
            Assert.fail((String)"Command should have exited with non-zero");
        }
        catch (ContainerExecException e) {
            Assert.assertTrue((boolean)e.getResult().getStderr().contains("Reason: Source " + sourceName + " doesn't exist"));
        }
    }
}

