/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.messaging;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.tests.integration.messaging.MessagingBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonDurableConsumerMessagingTest
extends MessagingBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceUrls")
    public void testNonDurableConsumer(Supplier<String> serviceUrl) throws Exception {
        String topicName = this.getNonPartitionedTopic("test-non-durable-consumer", false);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            int numMessages = 20;
            try (Producer producer = client.newProducer().topic(topicName).create();){
                IntStream.range(0, numMessages).forEach(i -> {
                    String payload = "message-" + i;
                    producer.sendAsync((Object)payload.getBytes(StandardCharsets.UTF_8));
                });
                producer.flush();
                try (Consumer consumer = client.newConsumer().topic(new String[]{topicName}).subscriptionName("non-durable-consumer").subscriptionMode(SubscriptionMode.NonDurable).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
                    for (int i2 = 0; i2 < numMessages; ++i2) {
                        Message msg = consumer.receive();
                        Assert.assertEquals((String)new String((byte[])msg.getValue(), StandardCharsets.UTF_8), (String)("message-" + i2));
                    }
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

