/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.offload;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.tests.integration.containers.S3Container;
import org.apache.pulsar.tests.integration.offload.TestBaseOffload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestUniversalConfigurations
extends TestBaseOffload {
    private static final Logger log = LoggerFactory.getLogger(TestUniversalConfigurations.class);
    private S3Container s3Container;

    @Override
    protected void beforeStartCluster() throws Exception {
        super.beforeStartCluster();
        log.info("s3 container init");
        this.s3Container = (S3Container)((S3Container)new S3Container(this.pulsarCluster.getClusterName(), "s3").withNetwork(this.pulsarCluster.getNetwork())).withNetworkAliases(new String[]{"s3"});
        this.s3Container.start();
        log.info("s3 container start finish.");
    }

    @AfterClass(alwaysRun=true)
    public void teardownS3() {
        if (null != this.s3Container) {
            this.s3Container.stop();
        }
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testPublishOffloadAndConsumeViaCLI(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testPublishOffloadAndConsumeViaCLI(serviceUrl.get(), adminUrl.get());
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testPublishOffloadAndConsumeViaThreshold(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testPublishOffloadAndConsumeViaThreshold(serviceUrl.get(), adminUrl.get());
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testPublishOffloadAndConsumeDeletionLag(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testPublishOffloadAndConsumeDeletionLag(serviceUrl.get(), adminUrl.get());
    }

    @Override
    protected Map<String, String> getEnv() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("managedLedgerMaxEntriesPerLedger", String.valueOf(1024));
        result.put("managedLedgerMinLedgerRolloverTimeMinutes", "0");
        result.put("managedLedgerOffloadDriver", "aws-s3");
        result.put("managedLedgerOffloadBucket", "pulsar-integtest");
        result.put("managedLedgerOffloadServiceEndpoint", "http://s3:9090");
        return result;
    }
}

