/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.suites;

import java.util.function.Predicate;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class PulsarTestSuite
extends PulsarClusterTestBase {
    @BeforeClass(alwaysRun=true)
    public final void setupBeforeClass() throws Exception {
        this.setup();
    }

    @AfterClass(alwaysRun=true)
    public final void tearDownAfterClass() throws Exception {
        this.cleanup();
    }

    public static void retryStrategically(Predicate<Void> predicate, int retryCount, long intSleepTimeInMillis) throws Exception {
        PulsarTestSuite.retryStrategically(predicate, retryCount, intSleepTimeInMillis, false);
    }

    public static void retryStrategically(Predicate<Void> predicate, int retryCount, long intSleepTimeInMillis, boolean throwException) throws Exception {
        for (int i = 0; i < retryCount; ++i) {
            if (throwException) {
                if (i == retryCount - 1) {
                    throw new RuntimeException("Action was not successful after " + retryCount + " retries");
                }
                if (predicate.test(null)) {
                    break;
                }
            } else if (predicate.test(null) || i == retryCount - 1) break;
            Thread.sleep(intSleepTimeInMillis + intSleepTimeInMillis * (long)i);
        }
    }
}

