/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import org.apache.pulsar.tests.integration.containers.CSContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class PulsarGeoCluster {
    private static final Logger log = LoggerFactory.getLogger(PulsarGeoCluster.class);
    private final PulsarClusterSpec[] clusterSpecs;
    private final CSContainer csContainer;
    private final PulsarCluster[] clusters;

    public static PulsarGeoCluster forSpec(PulsarClusterSpec ... specs) {
        return new PulsarGeoCluster(specs);
    }

    public PulsarGeoCluster(PulsarClusterSpec ... clusterSpecs) {
        this.clusterSpecs = clusterSpecs;
        this.clusters = new PulsarCluster[clusterSpecs.length];
        this.csContainer = (CSContainer)((CSContainer)new CSContainer("geo-cluster").withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{"configuration-store"});
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = PulsarCluster.forSpec(this.clusterSpecs[i], this.csContainer);
        }
    }

    public void start() throws Exception {
        this.csContainer.start();
        log.info("Successfully started configuration store container.");
        for (PulsarCluster cluster : this.clusters) {
            cluster.start();
            log.info("Successfully started all components for cluster {}.", (Object)cluster.getClusterName());
        }
    }

    public void stop() throws Exception {
        for (PulsarCluster cluster : this.clusters) {
            cluster.stop();
            log.info("Successfully stopped all components for cluster {}.", (Object)cluster.getClusterName());
        }
        this.csContainer.stop();
        log.info("Successfully stopped configuration store container.");
    }

    public PulsarClusterSpec[] getClusterSpecs() {
        return this.clusterSpecs;
    }

    public CSContainer getCsContainer() {
        return this.csContainer;
    }

    public PulsarCluster[] getClusters() {
        return this.clusters;
    }
}

