/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarGeoCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarGeoClusterTestBase
extends PulsarTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarGeoClusterTestBase.class);
    private PulsarGeoCluster geoCluster;

    protected final void setup() throws Exception {
        this.setupCluster();
    }

    protected final void cleanup() throws Exception {
        this.tearDownCluster();
    }

    protected void setupCluster() throws Exception {
        this.setupCluster("");
    }

    public void setupCluster(String namePrefix) throws Exception {
        PulsarClusterSpec.PulsarClusterSpecBuilder[] specBuilders = new PulsarClusterSpec.PulsarClusterSpecBuilder[2];
        for (int i = 0; i < 2; ++i) {
            String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), namePrefix, String.valueOf(i), PulsarGeoClusterTestBase.randomName(5)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("-"));
            specBuilders[i] = PulsarClusterSpec.builder().clusterName(clusterName);
        }
        specBuilders = this.beforeSetupCluster(specBuilders);
        PulsarClusterSpec[] specs = new PulsarClusterSpec[2];
        for (int i = 0; i < specBuilders.length; ++i) {
            specs[i] = specBuilders[i].build();
        }
        this.setupCluster0(specs);
    }

    protected PulsarClusterSpec.PulsarClusterSpecBuilder[] beforeSetupCluster(PulsarClusterSpec.PulsarClusterSpecBuilder ... specBuilder) {
        return specBuilder;
    }

    protected void setupCluster0(PulsarClusterSpec ... specs) throws Exception {
        this.incrementSetupNumber();
        log.info("Setting up geo cluster with {} local clusters}", (Object)specs.length);
        this.geoCluster = PulsarGeoCluster.forSpec(specs);
        this.beforeStartCluster();
        this.geoCluster.start();
        log.info("Geo Cluster is setup!");
    }

    protected void beforeStartCluster() throws Exception {
    }

    public void tearDownCluster() throws Exception {
        this.markCurrentSetupNumberCleaned();
        if (null != this.geoCluster) {
            this.geoCluster.stop();
        }
    }

    public PulsarGeoCluster getGeoCluster() {
        return this.geoCluster;
    }
}

